% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MA_effectsTable.R
\name{MA_effectsTable}
\alias{MA_effectsTable}
\title{Generate an ANOVA-like effects table for a meta-analysis.}
\usage{
MA_effectsTable(model, dataFrame, weights, tau2_model = "DL")
}
\arguments{
\item{model}{A two-sided linear formula object describing the model, with the
response (effect sizes) on the left of a ~ operator and the moderator
variables, separated by +, :, * operators, on the right.}

\item{dataFrame}{An optional data frame containing the variables named in the
model.}

\item{weights}{A column label from data.frame of variances to be used as weights.}

\item{tau2_model}{Specifies the between-study variance estimator.  Default
   is \code{"DL"}.}
}
\description{
Generates an ANOVA-like effects table that summarizes the within and between-study
homogeneity tests (Q-tests), as well as moderator level Q-tests as originally
described by Hedges and Olkin (1985; p. 156).
}
\references{
Hedges, L.V., and I. Olkin. 1985. Statistical methods for
   meta-analysis. Academic Press, New York, USA.
}

