% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_point_biserial_COR.R
\name{es_from_pt_bis_r_pval}
\alias{es_from_pt_bis_r_pval}
\title{Convert a p-value of a point-biserial correlation coefficient into several effect size measures}
\usage{
es_from_pt_bis_r_pval(
  pt_bis_r_pval,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_pt_bis_r_pval
)
}
\arguments{
\item{pt_bis_r_pval}{p-value of a point-biserial correlation coefficient}

\item{n_exp}{total number of participants in the exposed group}

\item{n_nexp}{total number of participants in the non exposed group}

\item{smd_to_cor}{formula used to convert the \code{pt_bis_r_pval} value into a coefficient correlation.}

\item{reverse_pt_bis_r_pval}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 11. ANOVA statistics, Student's t-test, or point-bis correlation'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a p-value of a point-biserial correlation coefficient into several effect size measures
}
\details{
This function converts the p-value of a point biserial correlation into a Student's t-value.

\strong{The formula used to obtain this Student's t-value is}:
\deqn{t = pt(\frac{pt\_bis\_r\_pval}{2}, df = n\_exp + n\_nexp - 2)}

Calculations of the \code{\link{es_from_student_t}} function are then applied.
}
\examples{
es_from_pt_bis_r_pval(pt_bis_r_pval = 0.2, n_exp = 121, n_nexp = 121)
}
\references{
Lipsey, M. W., & Wilson, D. B. (2001). Practical meta-analysis. Sage Publications, Inc.
}
