% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_IRR.R
\name{es_from_cases_time}
\alias{es_from_cases_time}
\title{Convert the number of cases and the person-time of disease-free observation in two independent groups into an incidence rate ratio (IRR)}
\usage{
es_from_cases_time(n_cases_exp, n_cases_nexp, time_exp, time_nexp, reverse_irr)
}
\arguments{
\item{n_cases_exp}{number of cases in the exposed group}

\item{n_cases_nexp}{number of cases in the non-exposed group}

\item{time_exp}{person-time of disease-free observation in the exposed group}

\item{time_nexp}{person-time of disease-free observation in the non-exposed group}

\item{reverse_irr}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates IRR.

\tabular{ll}{
\code{natural effect size measure} \tab IRR\cr
\tab \cr
\code{converted effect size measure} \tab N/A\cr
\tab \cr
\code{required input data} \tab See 'Section 5. Incidence Ratio Ratio'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert the number of cases and the person-time of disease-free observation in two independent groups into an incidence rate ratio (IRR)
}
\details{
This function estimates the incidence rate ratio from the number of cases and
the person-time of disease-free observation in two independent groups.

\strong{The formula used to obtain the IRR and its standard error} are (Cochrane Handbook (section 6.7.1):
\deqn{logirr = log(\frac{n\_cases\_exp / time\_exp}{n\_cases\_nexp / time\_nexp)}}
\deqn{logirr\_se = \sqrt{\frac{1}{n\_cases\_exp} + \frac{1}{n\_cases\_nexp}}}
}
\examples{
es_from_cases_time(
  n_cases_exp = 241, n_cases_nexp = 554,
  time_exp = 12.764, time_nexp = 19.743
)
}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
