% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc.R
\name{SBC_test}
\alias{SBC_test}
\title{Simulation based calibration}
\usage{
SBC_test(
  ...,
  pars,
  n.draw = 25L,
  n.sim = 20L * n.draw,
  burnin = 25L,
  thin = 2L,
  show.progress = TRUE,
  verbose = TRUE,
  n.cores = 1L,
  cl = NULL,
  seed = NULL,
  export = NULL
)
}
\arguments{
\item{...}{passed to \code{\link{create_sampler}} (can be all parameters except \code{prior.only})}

\item{pars}{named list with univariate functions of the parameters to use in test. This list
is passed to argument \code{pred} of \code{\link{MCMCsim}}.}

\item{n.draw}{number of posterior draws to retain in posterior simulations.}

\item{n.sim}{number of simulation iterations.}

\item{burnin}{burnin to use in posterior simulations, passed to \code{\link{MCMCsim}}.}

\item{thin}{thinning to use in posterior simulations, passed to \code{\link{MCMCsim}}.}

\item{show.progress}{whether a progress bar should be shown.}

\item{verbose}{set to \code{FALSE} to suppress messages.}

\item{n.cores}{the number of cpu cores to use. Default is one, i.e. no parallel computation.
If an existing cluster \code{cl} is provided, \code{n.cores} will be set to the number
of workers in that cluster.}

\item{cl}{an existing cluster can be passed for parallel computation. If \code{NULL} and
\code{n.cores > 1}, a new cluster is created.}

\item{seed}{a random seed (integer). For parallel computation it is used to independently
seed RNG streams for all workers.}

\item{export}{a character vector with names of objects to export to the workers. This may
be needed for parallel execution if expressions in the model formulae depend on global variables.}
}
\value{
A matrix with ranks.
}
\description{
Simulation based calibration
}
\examples{
\dontrun{
# this example may take a long time
n <- 10L
dat <- data.frame(x=runif(n))
ranks <- SBC_test(~ reg(~ 1 + x, prior=pr_normal(mean=c(0.25, 1), precision=1), name="beta"),
  sigma.mod=pr_invchisq(df=1, scale=list(df=1, scale=1)), data=dat,
  pars=list(mu="beta[1]", beta_x="beta[2]", sigma="sigma_"),
  n.draw=9L, n.sim=10L*20L, thin=2L, burnin=20L
)
ranks
}

}
\references{
M. Modrak, A.H. Moon, S. Kim, P. Buerkner, N. Huurre, K. Faltejskova,
    A. Gelman and A. Vehtari (2023).
    Simulation-based calibration checking for Bayesian computation:
    The choice of test quantities shapes sensitivity.
    Bayesian Analysis, 1(1), 1-28.
}
