% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMRF_extension.R
\name{GMRF_structure}
\alias{GMRF_structure}
\title{Set a GMRF structure for a generic model component}
\usage{
GMRF_structure(
  type = c("default", "bym2", "leroux"),
  scale.precision = (type == "bym2"),
  prior = NULL,
  control = NULL
)
}
\arguments{
\item{type}{one of "default", "bym2" or "leroux". The default choice
corresponds to the precision matrix \eqn{Q_A} as specified by argument \code{factor}
of \code{gen}. Type "bym2" modifies the default structure to one with
covariance matrix \eqn{\phi \tilde{Q}_{A}^- + (1 - \phi) I} where
\eqn{\tilde{Q}_{A*}^-} is the generalized inverse of \eqn{Q_A}, by default
scaled such that the geometric mean of the marginal variances equals 1.
Type "leroux" modifies the default structure to one with precision matrix
\eqn{\phi Q_A + (1 - \phi) I}.}

\item{scale.precision}{whether to scale the structured precision matrix. By default
set to \code{TRUE} only for type "bym2".}

\item{prior}{prior for the parameter \eqn{phi} in the "bym2" or "leroux" extension.
Supported priors can be set using functions \code{\link{pr_fixed}} or \code{\link{pr_unif}}.}

\item{control}{options for the Metropolis-Hastings sampler used to sample
from the full conditional distribution of parameter \eqn{phi} in case of
"bym2" or "leroux" extensions. If \code{NULL} a reasonable default configuration
is used. A user can change these settings using function \code{\link{set_MH}}.
Supported proposal distribution types are "RWTN", "RWN", "unif" and "beta".}
}
\value{
An environment defining the desired GMRF structure, for use by other
 package functions.
}
\description{
This function is used to specify a (non-default) GMRF structure
to pass to argument \code{strucA} of function \code{\link{gen}}.
}
\references{
B. Leroux, X. Lei and N. Breslow (1999).
   Estimation of Disease Rates in Small Areas: A New Mixed Model for Spatial Dependence.
   In M. Halloran and D. Berry (Eds.), Statistical Models in Epidemiology,
   the Environment and Clinical Trials, 135-178.

 A. Riebler, S.H. Sorbye, D. Simpson and H. Rue (2016).
   An intuitive Bayesian spatial model for disease mapping that accounts for scaling.
   Statistical methods in medical research, 25(4), 1145-1165.
}
