% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{simulateShares}
\alias{simulateShares}
\title{Simulate expected shares}
\usage{
simulateShares(
  model,
  alts,
  obsIDName = NULL,
  priceName = NULL,
  computeCI = TRUE,
  alpha = 0.025,
  numDraws = 10^4
)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.}

\item{alts}{A data frame of a set of alternatives for which to simulate
shares. Each row is an alternative and each column an attribute
corresponding to parameter names in the estimated model.}

\item{obsIDName}{The name of the column that identifies each set of
alternatives. Required if simulating results for more than one set of
alternatives. Defaults to \code{NULL} (for a single set of alternatives).}

\item{priceName}{The name of the parameter that identifies price. Only
required for WTP space models. Defaults to \code{NULL}.}

\item{computeCI}{Should a confidence interval be computed?
Defaults to \code{TRUE}.}

\item{alpha}{The sensitivity of the computed confidence interval.
Defaults to \code{alpha = 0.025}, reflecting a 95\% CI.}

\item{numDraws}{The number of draws to use in simulating uncertainty
for the computed confidence interval.}
}
\value{
A data frame with the estimated shares for each alternative in
\code{alts}.
}
\description{
This function has been depreciated since logitr version 0.1.4. Use
\code{predictProbs()} instead.
}
\keyword{internal}
\keyword{logitr}
\keyword{simulation}
