% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{read.liquidSVM}
\alias{read.liquidSVM}
\alias{serialize.liquidSVM}
\alias{unserialize.liquidSVM}
\alias{write.liquidSVM}
\title{Read and Write Solution from and to File}
\usage{
read.liquidSVM(filename, ...)

write.liquidSVM(model, filename)

serialize.liquidSVM(model, writeData = TRUE)

unserialize.liquidSVM(obj, ...)
}
\arguments{
\item{filename}{the filename to read from/save to. Can be relative to the working directory.}

\item{...}{passed to \code{\link{init.liquidSVM}}}

\item{model}{the model}

\item{writeData}{whether the training data should be serialized in the stream}

\item{obj}{the data to unserialize}
}
\description{
Reads or writes the solution from or to a file.
The format of the solutions is the same as used in the command line version of liquidSVM.
In addition also configuration data is written and by default also the training data.
This can be interchanged also with the other bindings.
}
\details{
The command line version of liquidSVM saves solutions
after select in files of the name \emph{data}\code{.sol} or \emph{data}\code{.fsol} and
uses those in the test-phase.
\code{read.liquidSVM} and \code{write.liquidSVM} read and write the same format at the specified path.
If you give a \code{filename} using extension \code{.fsol} the training data
is written to the file and read from it. On the other hand,
if you use the \code{.sol} format, you need to be able to reproduce
the same data again once you read the solution.
\code{readSolution} creates a new svm object.
}
\note{
This is not tested thoroughly so use in production is at your own risk.
Furthermore the serialize/unserialize hooks write temporary files.
}
\examples{
\dontrun{
banana <- liquidData('banana-bc')
modelOrig <- mcSVM(Y~., banana$train)
write.liquidSVM(modelOrig, "banana-bc.fsol")
write.liquidSVM(modelOrig, "banana-bc.sol")
clean(modelOrig) # delete the SVM object

# now we read it back from the file
modelRead <- read.liquidSVM("banana-bc.fsol")
# No need to train/select the data!
errors(test(modelRead, banana$test))

# to read the model where no data was saved we have to make sure, we get the same training data:
banana <- liquidData('banana-bc')
# then we can read it
modelDataExternal <- read.liquidSVM("banana-bc.sol", Y~., banana$train)
result <- test(modelDataExternal, banana$test)

# to serialize an object use:
banana <- liquidData('banana-bc')
modelOrig <- mcSVM(Y~., banana$train)
# we serialize it into a raw vector
obj <- serialize.liquidSVM(modelOrig)
clean(modelOrig) # delete the SVM object

# now we unserialize it from that raw vector
modelUnserialized <- unserialize.liquidSVM(obj)
errors(test(modelUnserialized, banana$test))
}
}
\seealso{
\code{\link{init.liquidSVM}}, \code{\link{write.liquidSVM}}
}

