% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldcat-api.R
\name{worldcat_api_bib_read_info_by}
\alias{worldcat_api_bib_read_info_by}
\alias{worldcat_api_bib_read_info_by_oclc}
\alias{worldcat_api_bib_read_info_by_isbn}
\alias{worldcat_api_bib_read_info_by_issn}
\title{Get bibliographic info from a standard number}
\usage{
worldcat_api_bib_read_info_by_oclc(
  x,
  wskey = getOption("libbib.wskey", NULL),
  more = FALSE,
  debug = FALSE
)

worldcat_api_bib_read_info_by_isbn(
  x,
  wskey = getOption("libbib.wskey", NULL),
  more = FALSE,
  debug = FALSE
)

worldcat_api_bib_read_info_by_issn(
  x,
  wskey = getOption("libbib.wskey", NULL),
  more = FALSE,
  debug = FALSE
)
}
\arguments{
\item{x}{A string representation of the standard number that the function
chosen accepts.}

\item{wskey}{A WorldCat API key (default is \code{getOption("libbib.wskey")})}

\item{more}{A logical indicating whether more infomation from the MARCXML
should be returned (publisher, bib level etc....) In the
interest of memory consumption, the default is \code{FALSE}}

\item{debug}{A logical indicating whether the HTTP and bib read API
responses should be printed (for debugging)
(default is \code{FALSE})}
}
\value{
A \code{data.table} containing the OCLC number, ISBN, ISSN,
        title, author, MARC leader, and the 008 control field,
        respectively,
}
\description{
Access the results of a WorldCat bib read API search by ISBN, ISSN,
or OCLC number. The MARCXML returned by the API is parsed and the
function returns a \code{data.table} containing the oclc number,
ISBN, ISSN, title, author, MARC leader, and the 008 control field,
respectively.
}
\details{
Though this function gets all standard numbers (OCLC, ISBN, ISSN)
from the MARCXML, the standard number that was supplied to the function
will be the one in the returned \code{data.table}. For example, if
you use \code{worldcat_api_bib_read_info_by_isbn}, the returned
\code{data.table} will have that ISBN in the ISBN column, not the
ISBN in the MARC record.

If something went wrong, all columns (except the one corresponding to
the supplied standard number) will be NA.

This function is helpful to call before attempting to use
the Location and Classify API functions as it will ensure that
the supplied standard number actually resolves to a OCLC work.

As with all API access functions in this package, it's up to the
user to limit their API usage so as to not get blocked. These
functions are deliberately not vectorized for this reason; they
only accept one standard number at a time.

This (and other) WorldCat API communication functions require a
WorldCat API key. The easiest way to use these functions is to
set a global options with your key:
\code{options("libbib.wskey"="YOUR KEY HERE")}

Final note: all of these API functions seem to work better with
OCLC numbers than any other standard number. If multiple standard
numbers are available, using the OCLC number is always preferred.
}
\examples{

\dontrun{
worldcat_api_bib_read_info_by_isbn("9780984201006")
#         oclc          isbn   issn                        title
#       <char>        <char> <char>                       <char>
# 1: 462894360 9780984201006   <NA> The Great Debate about Art /
#          author                   leader
#          <char>                   <char>
# 1: Harris, Roy, 00000cam a2200000 a 4500
#                                        oh08
#                                      <char>
# 1: 091031s2010    ilua     b    000 0 eng c

worldcat_api_bib_read_info_by_issn("13602365")
#        oclc   isbn     issn                        title author
#      <char> <char>   <char>                       <char> <char>
# 1: 37787277   <NA> 14664410 The journal of architecture.   <NA>
#                      leader                                     oh08
#                      <char>                                   <char>
# 1: 00000cas a2200000 a 4500 971015c19969999enkbx pso     0   a0eng c

}

}
