% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.lddf}
\alias{plot.lddf}
\title{Plot the output of \code{\link{mldest}()} or
\code{\link{sldest}()} using \code{\link[corrplot]{corrplot}()}}
\usage{
\method{plot}{lddf}(
  x,
  element = "r2",
  type = c("upper", "full", "lower"),
  method = c("color", "circle", "square", "ellipse", "number", "shade", "pie"),
  diag = FALSE,
  is.corr = NULL,
  tl.pos = "n",
  title = NULL,
  na.label = "square",
  ...
)
}
\arguments{
\item{x}{An object of class \code{lddf}, usually created using
either \code{\link{mldest}()} or \code{\link{sldest}()}.}

\item{element}{Which element of \code{x} should we plot?}

\item{type}{Character, \code{"full"},
\code{"upper"} (default) or \code{"lower"}, display
full matrix, lower triangular or upper
triangular matrix.}

\item{method}{See \code{\link[corrplot]{corrplot}()} for available options.
Default value is \code{"color"}.}

\item{diag}{Logical, whether display the correlation coefficients
on the principal diagonal.}

\item{is.corr}{See \code{\link[corrplot]{corrplot}()}. Default behavior
is \code{TRUE} if an element is constrained
between -1 and 1 and \code{FALSE} otherwise.}

\item{tl.pos}{See \code{\link[corrplot]{corrplot}()}. Default value
is \code{"n"}.}

\item{title}{What should the title be? Defaults to the element name.}

\item{na.label}{See \code{\link[corrplot]{corrplot}()}. Default value
is \code{"square"}.}

\item{...}{Additional arguments to pass to
\code{\link[corrplot]{corrplot}()}. See the documentation of that
function for options.}
}
\value{
(Invisibly) returns a matrix of the selected elements.
}
\description{
Formats the LD estimates in the form of a matrix and creates a heatmap of
these estimates. This heatmap is created using the
\code{\link[corrplot]{corrplot}} R package. I've adjusted a lot of the defaults
to suit my visualization preferences.
}
\details{
For greater plotting flexibility, see \code{\link[corrplot]{corrplot}()}
for the parameter options.
}
\examples{
set.seed(1)

## Simulate genotypes when true correlation is 0
nloci <- 5
nind  <- 100
K <- 6
nc <- 1
genomat <- matrix(sample(0:K, nind * nloci, TRUE), nrow = nloci)

## Gametic LD estimates
lddf <- mldest(geno = genomat,
               K = K,
               nc = nc,
               type = "gam")

## Plot estimates of z
plot(lddf, element = "z")

}
\author{
David Gerard
}
