% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_reg.R
\name{lavaan_reg}
\alias{lavaan_reg}
\title{Extract relevant regression indices from lavaan model}
\usage{
lavaan_reg(fit, nice_table = FALSE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract fit indices from}

\item{nice_table}{Logical, whether to print the table as a
\link[rempsyc:nice_table]{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \link[rempsyc:nice_table]{rempsyc::nice_table}}
}
\value{
A dataframe, including the outcome ("lhs"), predictor ("rhs"),
standardized regression coefficient ("std.all"), corresponding
p-value, as well as the unstandardized regression coefficient
("est") and its confidence interval ("ci.lower", "ci.upper").
}
\description{
Extract relevant regression indices from lavaan model through
\link[lavaan:parameterEstimates]{lavaan::parameterEstimates} and \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(regression <- list(
  ageyr = c("visual", "textual", "speed"),
  grade = c("visual", "textual", "speed")
))

HS.model <- write_lavaan(latent = latent, regression = regression)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
lavaan_reg(fit)
\dontshow{\}) # examplesIf}
}
