% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{RateOfChange-class}
\alias{RateOfChange-class}
\alias{.RateOfChange}
\title{Rate of Change}
\description{
An S4 class to represent rates of change from an aoristic analysis.
}
\section{Slots}{

\describe{
\item{\code{replicates}}{A non-negative \code{\link{integer}} giving the number of
replications.}

\item{\code{groups}}{A \code{\link{character}} vector to store the group names (if any).}
}}

\note{
This class inherits from \code{\link[aion:TimeSeries-class]{aion::TimeSeries}}: dates are internally
stored as \emph{\link[aion:RataDie-class]{rata die}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is an \code{AoristicSum} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{AoristicSum-class}},
\code{\link{CountApportion-class}},
\code{\link{EventDate-class}},
\code{\link{IncrementTest-class}},
\code{\link{MeanDate-class}},
\code{\link{PermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
