% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_time}
\alias{plot_time}
\alias{plot_time-method}
\alias{plot_time,data.frame,numeric-method}
\alias{plot_time,matrix,numeric-method}
\title{Abundance vs Time Plot}
\usage{
plot_time(object, dates, ...)

\S4method{plot_time}{data.frame,numeric}(object, dates, facet = FALSE)

\S4method{plot_time}{matrix,numeric}(object, dates, facet = FALSE)
}
\arguments{
\item{object}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{dates}{A \code{\link{numeric}} vector of dates.}

\item{...}{Currently not used.}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels defined by
type/taxon be drawn?}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object.
}
\description{
Produces an abundance \emph{vs} time diagram.
}
\examples{
data("merzbach", package = "folio")

## Coerce the merzbach dataset to a count matrix
## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
counts <- merzbach[, keep]

## Set dates
## We use the row names as time coordinates (roman numerals)
dates <- as.numeric(utils::as.roman(rownames(counts)))

## Plot abundance vs time
plot_time(counts, dates)
plot_time(counts, dates, facet = TRUE)
}
\seealso{
Other plotting methods: 
\code{\link{plot_aoristic}},
\code{\link{plot_event}},
\code{\link{plot_fit}},
\code{\link{plot_mcd}}
}
\author{
N. Frerebeau
}
\concept{plotting methods}
