% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/apportion.R
\docType{methods}
\name{apportion}
\alias{apportion}
\alias{apportion-method}
\alias{apportion,data.frame-method}
\alias{apportion,matrix-method}
\title{Chronological Apportioning}
\usage{
apportion(object, ...)

\S4method{apportion}{data.frame}(
  object,
  s0,
  s1,
  t0,
  t1,
  from = min(s0),
  to = max(s1),
  step = 25,
  method = c("uniform", "truncated"),
  z = 2,
  progress = getOption("kairos.progress")
)

\S4method{apportion}{matrix}(
  object,
  s0,
  s1,
  t0,
  t1,
  from = min(s0),
  to = max(s1),
  step = 25,
  method = c("uniform", "truncated"),
  z = 2,
  progress = getOption("kairos.progress")
)
}
\arguments{
\item{object}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{s0}{A length-\eqn{m} \code{\link{numeric}} vector giving the site beginning dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{s1}{A length-\eqn{m} \code{\link{numeric}} vector giving the site end dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{t0}{A length-\eqn{p} \code{\link{numeric}} vector giving the type beginning dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{t1}{A length-\eqn{p} \code{\link{numeric}} vector giving the type end dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{from}{A length-one \code{\link{numeric}} vector giving the beginning of the
period of interest (in years CE).}

\item{to}{A length-one \code{\link{numeric}} vector giving the end of the period of
interest (in years CE).}

\item{step}{A length-one \code{\link{integer}} vector giving the step size, i.e. the
width of each time step for apportioning (in years CE; defaults to
\eqn{25}).}

\item{method}{A \code{\link{character}} string specifying the distribution to be used
(type popularity curve). It must be one of "\code{uniform}" (uniform
distribution) or "\code{truncated}" (truncated standard normal distribution).
Any unambiguous substring can be given.}

\item{z}{An \code{\link{integer}} value giving the lower and upper truncation points
(defaults to \eqn{2}). Only used if \code{method} is "\code{truncated}".}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}
}
\description{
Chronological Apportioning
}
\references{
Roberts, J. M., Mills, B. J., Clark, J. J., Haas, W. R., Huntley, D. L. &
Trowbridge, M. A. (2012). A Method for Chronological Apportioning of Ceramic
Assemblages. \emph{Journal of Archaeological Science}, 39(5): 1513-20.
\doi{10.1016/j.jas.2011.12.022}.
}
\seealso{
Other chronological analysis: 
\code{\link{aoristic}()},
\code{\link{fit}()},
\code{\link{roc}()}
}
\author{
N. Frerebeau
}
\concept{chronological analysis}
