% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/fit.R
\docType{methods}
\name{fit}
\alias{fit}
\alias{fit-method}
\alias{fit,data.frame,numeric-method}
\alias{fit,matrix,numeric-method}
\title{Frequency Increment Test}
\usage{
fit(object, dates, ...)

\S4method{fit}{data.frame,numeric}(object, dates)

\S4method{fit}{matrix,numeric}(object, dates)
}
\arguments{
\item{object}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{dates}{A \code{\link{numeric}} vector of dates expressed in CE years (BCE years
must be given as negative numbers).}

\item{...}{Currently not used.}
}
\value{
An \linkS4class{IncrementTest} object.
}
\description{
Frequency Increment Test
}
\details{
The Frequency Increment Test (FIT) rejects neutrality if the distribution
of normalized variant frequency increments exhibits a mean that deviates
significantly from zero.
}
\examples{
data("merzbach", package = "folio")

## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
counts <- merzbach[, keep]

## Group by phase
## We use the row names as time coordinates (roman numerals)
dates <- as.numeric(utils::as.roman(rownames(counts)))

## Frequency Increment Test
freq <- fit(counts, dates)

## Plot time vs abundance and highlight selection
plot(freq)
plot(freq, roll = TRUE, window = 5)
}
\references{
Feder, A. F., Kryazhimskiy, S. & Plotkin, J. B. (2014). Identifying
Signatures of Selection in Genetic Time Series. \emph{Genetics}, 196(2):
509-522. \doi{10.1534/genetics.113.158220}.
}
\seealso{
\link[=plot_fit]{plot()}

Other chronological analysis: 
\code{\link{aoristic}()},
\code{\link{apportion}()},
\code{\link{roc}()}
}
\author{
N. Frerebeau
}
\concept{chronological analysis}
