% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-rtf.R
\name{rtf_parse_year}
\alias{rtf_parse_year}
\title{parse RTF description of entire ICD-9-CM for a specific year}
\source{
http://ftp.cdc.gov/pub/Health_Statistics/NCHS/Publications/ICD9-CM/2011/Dtab12.zip
and similar files run from 1996 to 2011.
}
\usage{
rtf_parse_year(year = "2011", ..., save_data = FALSE, verbose = FALSE,
  offline = TRUE)
}
\arguments{
\item{year}{from 1996 to 2012 (this is what CDC has published). Only 2012
implemented thus far}

\item{save_data}{single logical value, if \code{TRUE} will save the generated
data}

\item{verbose}{single logical value, defaults to \code{FALSE} in most functions.}
}
\description{
Currently only the most recent update is implemented. Note that CMS have
published additional ICD-9-CM billable code lists since the last one from the
CDC: I think these have been the same every year since 2011, though. The last
CDC release is \code{Dtab12.rtf} from 2011.
}
\details{
The file itself is 7 bit ASCII, but has its own internal encoding using
'CP1252.' Test 'Meniere's' disease with lines 24821 to 24822 from 2012 RTF
}
\keyword{internal}
