% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbid.R
\name{icd10_comorbid_parent_search}
\alias{icd10_comorbid_parent_search}
\title{find ICD-10 comorbidities by checking parents}
\usage{
icd10_comorbid_parent_search(x, map, visit_name = NULL,
  icd_name = get_icd_name(x), short_code = icd_guess_short(x, icd_name =
  icd_name), short_map = icd_guess_short(map), return_df = FALSE, ...)
}
\description{
find ICD-10 comorbidities by checking parents
}
\examples{
\dontrun{
up <- uranium_pathology[1:50, ]
stopifnot(identical(
icd:::icd10_comorbid_parent_search_orig(up, icd10_map_ahrq,
  visit_name = "case", icd_name = "icd10",
  short_code = FALSE, short_map = TRUE, return_df = FALSE),
icd:::icd10_comorbid_parent_search_use_cpp(up, icd10_map_ahrq,
  visit_name = "case", icd_name = "icd10",
  short_code = FALSE, short_map = TRUE, return_df = FALSE)
))

library(microbenchmark)
microbenchmark(substr("12345", 1, 4), substring("12345", 1, 4),
               stringr::str_sub("12345", 1, 4), times = 1e5)
# substr is fastest by a good margin

microbenchmark(
  icd10_comorbid_parent_search_str(uranium_pathology, icd10_map_ahrq,
    visit_name = "case", icd_name = "icd10",
    short_code = FALSE, short_map = TRUE, return_df = FALSE),
  icd10_comorbid_parent_search_use_cpp(uranium_pathology, icd10_map_ahrq,
    visit_name = "case", icd_name = "icd10",
    short_code = FALSE, short_map = TRUE, return_df = FALSE),
  icd10_comorbid_parent_search_all(uranium_pathology, icd10_map_ahrq,
    visit_name = "case", icd_name = "icd10",
    short_code = FALSE, short_map = TRUE, return_df = FALSE),
  icd10_comorbid_parent_search_no_loop(uranium_pathology, icd10_map_ahrq,
    visit_name = "case", icd_name = "icd10",
    short_code = FALSE, short_map = TRUE, return_df = FALSE),
  icd10_comorbid_parent_search_orig(uranium_pathology, icd10_map_ahrq,
    visit_name = "case", icd_name = "icd10",
    short_code = FALSE, short_map = TRUE, return_df = FALSE),
  times = 3)
}
}
\keyword{internal}
