% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-comorbid.R
\name{icd9_parse_quan_deyo_sas}
\alias{icd9_parse_quan_deyo_sas}
\title{parse original SAS code defining Quan's update of Deyo comorbidities.}
\usage{
icd9_parse_quan_deyo_sas(save_data = FALSE)
}
\arguments{
\item{save_data}{logical whether to save the result in the source tree.
Defaults to \code{FALSE}.}

\item{condense}{Deprecated. The map is not condensed by default. If required,
it can reduced to a smaller set of codes using \code{icd_condense}.}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in
data-raw. This is helpful for testing without using the internet.}
}
\value{
invisibly returns the list of vectors, where a co-morbidity name is
  associated with a character vector of ICD-9 codes.
}
\description{
As with \code{parseAhrqSas}, this function reads SAS code, and
  in, a very limited way, extracts definitions. In this case the code uses
  LET statements, with strings or lists of strings. This saves and invisibly
  returns a list with names corresponding to the comorbidities and values as
  a vector of 'short' form (i.e. non-decimal) ICD9 codes. Unlike
  \code{icd9_parse_ahrq_sas}, there are no ranges defined, so this
  interpretation is simpler.
}
\details{
With thanks to Dr. Quan, I have permission to distribute his SAS code.
  Previously, the SAS code would be downloaded from the University of
  Manitoba at
  \url{http://mchp-appserv.cpe.umanitoba.ca/concept/ICD9_E_Charlson.sas.txt}.
  There are structural differences between this version and the version
  directly from Dr. Quan, however, the parsing results in identical data.
}
\keyword{internal}
\keyword{manip}

