% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dawson2023}
\alias{dawson2023}
\title{Machine Learning PFAS Half-Life Predictions from Dawson et al. 2023}
\format{
data.frame
}
\usage{
dawson2023
}
\description{
Dawson et al. (2023) Supplemental Information S3 includes half-life predictions 
for 6603 PFAS, of which 3890 are estimated to be within the applicability
domain (AD) for humans. This machine learning (ML) model predicts PFAS 
half-life as one of four categories. The ML model was trained to a dataset 
of 91 in vivo measured TK half-lives across 11 PFAS, 4 species, and two 
sexes. Predictions were a function of compound-specific physico-chemical 
descriptors, species-specific physiological descriptors, and an indicator 
variable for sex. The kinetics of PFAS are thought to be complicated by 
active transport, both through either proximal tubular resorption (into the 
blood) (Andersen et al. 2006) or secretion (into the urine) 
(Kudo et al. 2002). The ML model uses several species- and structure-derived
surrogates for estimating the likelihood of active PFAS transport. Geometry
of the proximal tubule was a surrogate for transporter expression: since
secretion/resorption transporters line the surface of the proximal tubule,
the amount of surface area provides an upper limit on the amount of
transporter expression. PFAS similarity to three distinct endogenous ligands
was considered as a surrogate for transporter affinity.
}
\details{
The Dawson et al. (2023) half-life categories are:
\tabular{ll}{
\strong{Category} \tab \strong{Range of Half-Lives} \cr
 1 \tab < 12 hours \cr                      
 2 \tab < 1 week \cr                      
 3 \tab < 2 months \cr                      
 4 \tab > 2 months \cr                      
 }

The data.frame contains the following columns:
\tabular{ll}{
\strong{Column Name} \tab \strong{Description} \cr
 DTXSID \tab CompTox Chemicals Dashboard substance identifier \cr                      
 Species \tab Species for which the prediction was made \cr
 Sex \tab Sex for which the prediction was made \cr
 DosingAdj \tab Route of dose administration -- intravenous, oral, or other \cr
 ClassPredFull \tab The predicted half-life class (category) \cr  
 ClassModDomain \tab AD estimated from chemical classes of training set \cr
 AMAD \tab AD including AD predicted for each model used for descriptors \cr
}
}
\references{
\insertRef{dawson2023machine}{httk}

\insertRef{andersen2006pharmacokinetic}{httk}

\insertRef{kudo2002sex}{httk}
}
\keyword{data}
