% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMSE.R
\name{IMSE_nsteps_ahead}
\alias{IMSE_nsteps_ahead}
\title{h-IMSE with replication}
\usage{
IMSE_nsteps_ahead(model, h = 2, Xcand = NULL, control = list(multi.start =
  10, maxit = 100), Wijs = NULL)
}
\arguments{
\item{model}{\code{homGP} or \code{hetGP} model}

\item{h}{horizon (multi-step ahead framework)}

\item{Xcand}{optional discrete set of new candidates (otherwise a maximin LHS is used to initialise search)}

\item{control}{list to be passed to \code{\link[hetGP]{IMSE.search}}}

\item{Wijs}{optional previously computed matrix of Wijs, see \code{\link[hetGP]{Wij}}}
}
\value{
list with elements:
\itemize{
\item \code{par}: best first design,
\item \code{value}: IMSPE h-steps ahead starting from adding \code{par},
\item \code{path}: list of elements list(\code{par}, \code{value}, \code{new}) at each step \code{h}
}
}
\description{
h-steps lookahead strategy to favor designs with replication
}
\details{
The domain needs to be [0, 1]^d for now.
The decision is made between:
\itemize{
 \item sequential IMSE search starting by a new design (optimized first) then adding \code{h} replicates
 \item sequential IMSE searches starting by \code{1} to \code{h} replicates before adding a new point
}
}
\examples{
###############################################################################
## Bi-variate example
###############################################################################

nvar <- 2 

set.seed(42)
ftest <- function(x, coef = 0.1) return(sin(2*pi*sum(x)) + rnorm(1, sd = coef))

n <- 25 # must be a square
xgrid0 <- seq(0.1, 0.9, length.out = sqrt(n))
designs <- as.matrix(expand.grid(xgrid0, xgrid0))
X <- designs[rep(1:n, sample(1:10, n, replace = TRUE)),]
Z <- apply(X, 1, ftest)

model <- mleHomGP(X, Z, lower = rep(0.1, nvar), upper = rep(1, nvar))

\dontrun{ 
ngrid <- 51
xgrid <- seq(0,1, length.out = ngrid)
Xgrid <- as.matrix(expand.grid(xgrid, xgrid))

nsteps <- 5 # Increase for more steps

for(i in 1:nsteps){
  res <- IMSE_nsteps_ahead(model, h = 3, control = list(multi.start = 100, maxit = 50))
  
  # If a replicate is selected
  if(res$path[[1]]$new) print("Add replicate")
  
  newX <- res$par
  newZ <- ftest(newX)
  model <- update(object = model, Xnew = newX, Znew = newZ)
  
  ## Plots 
  preds <- predict(x = Xgrid, object =  model)
  contour(x = xgrid,  y = xgrid, z = matrix(preds$mean, ngrid),
          main = "Predicted mean", nlevels = 20)
  points(model$X0, col = 'blue', pch = 20)
  points(newX, col = "red", pch = 20)
  
  ## Precalculations
  Wijs <- Wij(mu1 = model$X0, theta = model$theta, type = model$covtype)
  
  IMSE_grid <- apply(Xgrid, 1, crit_IMSE, Wijs = Wijs, model = model)
  filled.contour(x = xgrid, y = xgrid, matrix(IMSE_grid, ngrid),
                 nlevels = 20, color.palette = terrain.colors,
  plot.axes = {axis(1); axis(2); points(model$X0, pch = 20)})
}
}
}
\references{
M. Binois, J. Huang, R. Gramacy, M. Ludkovski (2017+), Replication or exploration? Sequential design for stochastic simulation experiments.
}
