// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppEigen.h>
#include <Rcpp.h>

using namespace Rcpp;

// compute_split_frequencies
Rcpp::NumericMatrix compute_split_frequencies(Rcpp::List forest_object, size_t max_depth);
RcppExport SEXP _grf_compute_split_frequencies(SEXP forest_objectSEXP, SEXP max_depthSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< size_t >::type max_depth(max_depthSEXP);
    rcpp_result_gen = Rcpp::wrap(compute_split_frequencies(forest_object, max_depth));
    return rcpp_result_gen;
END_RCPP
}
// compute_weights
Eigen::SparseMatrix<double> compute_weights(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads);
RcppExport SEXP _grf_compute_weights(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(compute_weights(forest_object, train_matrix, sparse_train_matrix, test_matrix, sparse_test_matrix, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// compute_weights_oob
Eigen::SparseMatrix<double> compute_weights_oob(Rcpp::List forest_object, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads);
RcppExport SEXP _grf_compute_weights_oob(SEXP forest_objectSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(compute_weights_oob(forest_object, test_matrix, sparse_test_matrix, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// merge
Rcpp::List merge(const Rcpp::List forest_objects);
RcppExport SEXP _grf_merge(SEXP forest_objectsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type forest_objects(forest_objectsSEXP);
    rcpp_result_gen = Rcpp::wrap(merge(forest_objects));
    return rcpp_result_gen;
END_RCPP
}
// causal_train
Rcpp::List causal_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, size_t sample_weight_index, bool use_sample_weights, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double reduced_form_weight, double alpha, double imbalance_penalty, bool stabilize_splits, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_causal_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP reduced_form_weightSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP stabilize_splitsSEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type reduced_form_weight(reduced_form_weightSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< bool >::type stabilize_splits(stabilize_splitsSEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(causal_train(train_matrix, sparse_train_matrix, outcome_index, treatment_index, sample_weight_index, use_sample_weights, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, reduced_form_weight, alpha, imbalance_penalty, stabilize_splits, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// causal_predict
Rcpp::List causal_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_causal_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(causal_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, test_matrix, sparse_test_matrix, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// causal_predict_oob
Rcpp::List causal_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_causal_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(causal_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// ll_causal_predict
Rcpp::List ll_causal_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, std::vector<double> ll_lambda, bool ll_weight_penalty, std::vector<size_t> linear_correction_variables, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_ll_causal_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP ll_lambdaSEXP, SEXP ll_weight_penaltySEXP, SEXP linear_correction_variablesSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ll_lambda(ll_lambdaSEXP);
    Rcpp::traits::input_parameter< bool >::type ll_weight_penalty(ll_weight_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type linear_correction_variables(linear_correction_variablesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(ll_causal_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, test_matrix, sparse_test_matrix, ll_lambda, ll_weight_penalty, linear_correction_variables, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// ll_causal_predict_oob
Rcpp::List ll_causal_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, std::vector<double> ll_lambda, bool ll_weight_penalty, std::vector<size_t> linear_correction_variables, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_ll_causal_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP ll_lambdaSEXP, SEXP ll_weight_penaltySEXP, SEXP linear_correction_variablesSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ll_lambda(ll_lambdaSEXP);
    Rcpp::traits::input_parameter< bool >::type ll_weight_penalty(ll_weight_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type linear_correction_variables(linear_correction_variablesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(ll_causal_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, ll_lambda, ll_weight_penalty, linear_correction_variables, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// custom_train
Rcpp::List custom_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double alpha, double imbalance_penalty, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_custom_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(custom_train(train_matrix, sparse_train_matrix, outcome_index, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, alpha, imbalance_penalty, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// custom_predict
Rcpp::NumericMatrix custom_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads);
RcppExport SEXP _grf_custom_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(custom_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, test_matrix, sparse_test_matrix, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// custom_predict_oob
Rcpp::NumericMatrix custom_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, unsigned int num_threads);
RcppExport SEXP _grf_custom_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(custom_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// instrumental_train
Rcpp::List instrumental_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, size_t instrument_index, size_t sample_weight_index, bool use_sample_weights, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double reduced_form_weight, double alpha, double imbalance_penalty, bool stabilize_splits, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_instrumental_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP instrument_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP reduced_form_weightSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP stabilize_splitsSEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type instrument_index(instrument_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type reduced_form_weight(reduced_form_weightSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< bool >::type stabilize_splits(stabilize_splitsSEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(instrumental_train(train_matrix, sparse_train_matrix, outcome_index, treatment_index, instrument_index, sample_weight_index, use_sample_weights, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, reduced_form_weight, alpha, imbalance_penalty, stabilize_splits, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// instrumental_predict
Rcpp::List instrumental_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, size_t instrument_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_instrumental_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP instrument_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type instrument_index(instrument_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(instrumental_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, instrument_index, test_matrix, sparse_test_matrix, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// instrumental_predict_oob
Rcpp::List instrumental_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t treatment_index, size_t instrument_index, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_instrumental_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP treatment_indexSEXP, SEXP instrument_indexSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type treatment_index(treatment_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type instrument_index(instrument_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(instrumental_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, treatment_index, instrument_index, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// quantile_train
Rcpp::List quantile_train(std::vector<double> quantiles, bool regression_splitting, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, unsigned int mtry, unsigned int num_trees, int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double alpha, double imbalance_penalty, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, int num_threads, unsigned int seed);
RcppExport SEXP _grf_quantile_train(SEXP quantilesSEXP, SEXP regression_splittingSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::vector<double> >::type quantiles(quantilesSEXP);
    Rcpp::traits::input_parameter< bool >::type regression_splitting(regression_splittingSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(quantile_train(quantiles, regression_splitting, train_matrix, sparse_train_matrix, outcome_index, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, alpha, imbalance_penalty, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// quantile_predict
Rcpp::NumericMatrix quantile_predict(Rcpp::List forest_object, std::vector<double> quantiles, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads);
RcppExport SEXP _grf_quantile_predict(SEXP forest_objectSEXP, SEXP quantilesSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type quantiles(quantilesSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(quantile_predict(forest_object, quantiles, train_matrix, sparse_train_matrix, outcome_index, test_matrix, sparse_test_matrix, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// quantile_predict_oob
Rcpp::NumericMatrix quantile_predict_oob(Rcpp::List forest_object, std::vector<double> quantiles, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, unsigned int num_threads);
RcppExport SEXP _grf_quantile_predict_oob(SEXP forest_objectSEXP, SEXP quantilesSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP num_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type quantiles(quantilesSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(quantile_predict_oob(forest_object, quantiles, train_matrix, sparse_train_matrix, outcome_index, num_threads));
    return rcpp_result_gen;
END_RCPP
}
// regression_train
Rcpp::List regression_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t sample_weight_index, bool use_sample_weights, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double alpha, double imbalance_penalty, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_regression_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(regression_train(train_matrix, sparse_train_matrix, outcome_index, sample_weight_index, use_sample_weights, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, alpha, imbalance_penalty, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// regression_predict
Rcpp::List regression_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads, unsigned int estimate_variance);
RcppExport SEXP _grf_regression_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(regression_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, test_matrix, sparse_test_matrix, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// regression_predict_oob
Rcpp::List regression_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_regression_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(regression_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// ll_regression_train
Rcpp::List ll_regression_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t sample_weight_index, double ll_split_lambda, bool ll_split_weight_penalty, std::vector<size_t> ll_split_variables, size_t ll_split_cutoff, std::vector<double> overall_beta, bool use_sample_weights, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, size_t ci_group_size, double alpha, double imbalance_penalty, std::vector<size_t> clusters, unsigned int samples_per_cluster, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_ll_regression_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP sample_weight_indexSEXP, SEXP ll_split_lambdaSEXP, SEXP ll_split_weight_penaltySEXP, SEXP ll_split_variablesSEXP, SEXP ll_split_cutoffSEXP, SEXP overall_betaSEXP, SEXP use_sample_weightsSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP ci_group_sizeSEXP, SEXP alphaSEXP, SEXP imbalance_penaltySEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< double >::type ll_split_lambda(ll_split_lambdaSEXP);
    Rcpp::traits::input_parameter< bool >::type ll_split_weight_penalty(ll_split_weight_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type ll_split_variables(ll_split_variablesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ll_split_cutoff(ll_split_cutoffSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type overall_beta(overall_betaSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< size_t >::type ci_group_size(ci_group_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< double >::type imbalance_penalty(imbalance_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(ll_regression_train(train_matrix, sparse_train_matrix, outcome_index, sample_weight_index, ll_split_lambda, ll_split_weight_penalty, ll_split_variables, ll_split_cutoff, overall_beta, use_sample_weights, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, ci_group_size, alpha, imbalance_penalty, clusters, samples_per_cluster, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// ll_regression_predict
Rcpp::List ll_regression_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, std::vector<double> ll_lambda, bool ll_weight_penalty, std::vector<size_t> linear_correction_variables, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_ll_regression_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP ll_lambdaSEXP, SEXP ll_weight_penaltySEXP, SEXP linear_correction_variablesSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ll_lambda(ll_lambdaSEXP);
    Rcpp::traits::input_parameter< bool >::type ll_weight_penalty(ll_weight_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type linear_correction_variables(linear_correction_variablesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(ll_regression_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, test_matrix, sparse_test_matrix, ll_lambda, ll_weight_penalty, linear_correction_variables, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// ll_regression_predict_oob
Rcpp::List ll_regression_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, std::vector<double> ll_lambda, bool ll_weight_penalty, std::vector<size_t> linear_correction_variables, unsigned int num_threads, bool estimate_variance);
RcppExport SEXP _grf_ll_regression_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP ll_lambdaSEXP, SEXP ll_weight_penaltySEXP, SEXP linear_correction_variablesSEXP, SEXP num_threadsSEXP, SEXP estimate_varianceSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ll_lambda(ll_lambdaSEXP);
    Rcpp::traits::input_parameter< bool >::type ll_weight_penalty(ll_weight_penaltySEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type linear_correction_variables(linear_correction_variablesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< bool >::type estimate_variance(estimate_varianceSEXP);
    rcpp_result_gen = Rcpp::wrap(ll_regression_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, ll_lambda, ll_weight_penalty, linear_correction_variables, num_threads, estimate_variance));
    return rcpp_result_gen;
END_RCPP
}
// survival_train
Rcpp::List survival_train(Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t censor_index, size_t sample_weight_index, bool use_sample_weights, unsigned int mtry, unsigned int num_trees, unsigned int min_node_size, double sample_fraction, bool honesty, double honesty_fraction, bool honesty_prune_leaves, double alpha, size_t num_failures, std::vector<size_t> clusters, unsigned int samples_per_cluster, bool compute_oob_predictions, unsigned int num_threads, unsigned int seed);
RcppExport SEXP _grf_survival_train(SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP censor_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP mtrySEXP, SEXP num_treesSEXP, SEXP min_node_sizeSEXP, SEXP sample_fractionSEXP, SEXP honestySEXP, SEXP honesty_fractionSEXP, SEXP honesty_prune_leavesSEXP, SEXP alphaSEXP, SEXP num_failuresSEXP, SEXP clustersSEXP, SEXP samples_per_clusterSEXP, SEXP compute_oob_predictionsSEXP, SEXP num_threadsSEXP, SEXP seedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type censor_index(censor_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type mtry(mtrySEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_trees(num_treesSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type min_node_size(min_node_sizeSEXP);
    Rcpp::traits::input_parameter< double >::type sample_fraction(sample_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty(honestySEXP);
    Rcpp::traits::input_parameter< double >::type honesty_fraction(honesty_fractionSEXP);
    Rcpp::traits::input_parameter< bool >::type honesty_prune_leaves(honesty_prune_leavesSEXP);
    Rcpp::traits::input_parameter< double >::type alpha(alphaSEXP);
    Rcpp::traits::input_parameter< size_t >::type num_failures(num_failuresSEXP);
    Rcpp::traits::input_parameter< std::vector<size_t> >::type clusters(clustersSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type samples_per_cluster(samples_per_clusterSEXP);
    Rcpp::traits::input_parameter< bool >::type compute_oob_predictions(compute_oob_predictionsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type seed(seedSEXP);
    rcpp_result_gen = Rcpp::wrap(survival_train(train_matrix, sparse_train_matrix, outcome_index, censor_index, sample_weight_index, use_sample_weights, mtry, num_trees, min_node_size, sample_fraction, honesty, honesty_fraction, honesty_prune_leaves, alpha, num_failures, clusters, samples_per_cluster, compute_oob_predictions, num_threads, seed));
    return rcpp_result_gen;
END_RCPP
}
// survival_predict
Rcpp::List survival_predict(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t censor_index, size_t sample_weight_index, bool use_sample_weights, Rcpp::NumericMatrix test_matrix, Eigen::SparseMatrix<double> sparse_test_matrix, unsigned int num_threads, size_t num_failures);
RcppExport SEXP _grf_survival_predict(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP censor_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP test_matrixSEXP, SEXP sparse_test_matrixSEXP, SEXP num_threadsSEXP, SEXP num_failuresSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type censor_index(censor_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type test_matrix(test_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_test_matrix(sparse_test_matrixSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< size_t >::type num_failures(num_failuresSEXP);
    rcpp_result_gen = Rcpp::wrap(survival_predict(forest_object, train_matrix, sparse_train_matrix, outcome_index, censor_index, sample_weight_index, use_sample_weights, test_matrix, sparse_test_matrix, num_threads, num_failures));
    return rcpp_result_gen;
END_RCPP
}
// survival_predict_oob
Rcpp::List survival_predict_oob(Rcpp::List forest_object, Rcpp::NumericMatrix train_matrix, Eigen::SparseMatrix<double> sparse_train_matrix, size_t outcome_index, size_t censor_index, size_t sample_weight_index, bool use_sample_weights, unsigned int num_threads, size_t num_failures);
RcppExport SEXP _grf_survival_predict_oob(SEXP forest_objectSEXP, SEXP train_matrixSEXP, SEXP sparse_train_matrixSEXP, SEXP outcome_indexSEXP, SEXP censor_indexSEXP, SEXP sample_weight_indexSEXP, SEXP use_sample_weightsSEXP, SEXP num_threadsSEXP, SEXP num_failuresSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type forest_object(forest_objectSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type train_matrix(train_matrixSEXP);
    Rcpp::traits::input_parameter< Eigen::SparseMatrix<double> >::type sparse_train_matrix(sparse_train_matrixSEXP);
    Rcpp::traits::input_parameter< size_t >::type outcome_index(outcome_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type censor_index(censor_indexSEXP);
    Rcpp::traits::input_parameter< size_t >::type sample_weight_index(sample_weight_indexSEXP);
    Rcpp::traits::input_parameter< bool >::type use_sample_weights(use_sample_weightsSEXP);
    Rcpp::traits::input_parameter< unsigned int >::type num_threads(num_threadsSEXP);
    Rcpp::traits::input_parameter< size_t >::type num_failures(num_failuresSEXP);
    rcpp_result_gen = Rcpp::wrap(survival_predict_oob(forest_object, train_matrix, sparse_train_matrix, outcome_index, censor_index, sample_weight_index, use_sample_weights, num_threads, num_failures));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_grf_compute_split_frequencies", (DL_FUNC) &_grf_compute_split_frequencies, 2},
    {"_grf_compute_weights", (DL_FUNC) &_grf_compute_weights, 6},
    {"_grf_compute_weights_oob", (DL_FUNC) &_grf_compute_weights_oob, 4},
    {"_grf_merge", (DL_FUNC) &_grf_merge, 1},
    {"_grf_causal_train", (DL_FUNC) &_grf_causal_train, 23},
    {"_grf_causal_predict", (DL_FUNC) &_grf_causal_predict, 9},
    {"_grf_causal_predict_oob", (DL_FUNC) &_grf_causal_predict_oob, 7},
    {"_grf_ll_causal_predict", (DL_FUNC) &_grf_ll_causal_predict, 12},
    {"_grf_ll_causal_predict_oob", (DL_FUNC) &_grf_ll_causal_predict_oob, 10},
    {"_grf_custom_train", (DL_FUNC) &_grf_custom_train, 18},
    {"_grf_custom_predict", (DL_FUNC) &_grf_custom_predict, 7},
    {"_grf_custom_predict_oob", (DL_FUNC) &_grf_custom_predict_oob, 5},
    {"_grf_instrumental_train", (DL_FUNC) &_grf_instrumental_train, 24},
    {"_grf_instrumental_predict", (DL_FUNC) &_grf_instrumental_predict, 10},
    {"_grf_instrumental_predict_oob", (DL_FUNC) &_grf_instrumental_predict_oob, 8},
    {"_grf_quantile_train", (DL_FUNC) &_grf_quantile_train, 20},
    {"_grf_quantile_predict", (DL_FUNC) &_grf_quantile_predict, 8},
    {"_grf_quantile_predict_oob", (DL_FUNC) &_grf_quantile_predict_oob, 6},
    {"_grf_regression_train", (DL_FUNC) &_grf_regression_train, 20},
    {"_grf_regression_predict", (DL_FUNC) &_grf_regression_predict, 8},
    {"_grf_regression_predict_oob", (DL_FUNC) &_grf_regression_predict_oob, 6},
    {"_grf_ll_regression_train", (DL_FUNC) &_grf_ll_regression_train, 24},
    {"_grf_ll_regression_predict", (DL_FUNC) &_grf_ll_regression_predict, 11},
    {"_grf_ll_regression_predict_oob", (DL_FUNC) &_grf_ll_regression_predict_oob, 9},
    {"_grf_survival_train", (DL_FUNC) &_grf_survival_train, 20},
    {"_grf_survival_predict", (DL_FUNC) &_grf_survival_predict, 11},
    {"_grf_survival_predict_oob", (DL_FUNC) &_grf_survival_predict_oob, 9},
    {NULL, NULL, 0}
};

RcppExport void R_init_grf(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
