% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_greenspace.R
\name{nearest_greenspace}
\alias{nearest_greenspace}
\title{Calculate and Visualize the Shortest Walking Path to Specified Type of Nearest Green Space with Estimated Walking Time}
\usage{
nearest_greenspace(
  highway_data,
  green_areas_data,
  location_lat,
  location_lon,
  green_space_types = NULL,
  walking_speed_kmh = 4.5,
  osrm_server = "https://router.project-osrm.org/"
)
}
\arguments{
\item{highway_data}{List containing road network data, typically obtained from OpenStreetMap.}

\item{green_areas_data}{List containing green areas data, obtained from \code{get_osm_data}.}

\item{location_lat}{Numeric, latitude of the starting location.}

\item{location_lon}{Numeric, longitude of the starting location.}

\item{green_space_types}{Vector of strings specifying types of green spaces to consider.}

\item{walking_speed_kmh}{Numeric, walking speed in kilometers per hour, default is 4.5.}

\item{osrm_server}{URL of the OSRM routing server with foot routing support, default is "https://router.project-osrm.org/".}
}
\value{
A Leaflet map object showing the route, start point, and nearest green space with popup annotations.
}
\description{
Determines the nearest specified type of green space from a given location and calculates the
shortest walking route using the road network optimized for walking. The result is visualized on a Leaflet map
displaying the path, the starting location, and the destination green space, with details on distance and estimated walking time.
}
\examples{
\donttest{
  data <- get_osm_data("Fulham, London, United Kingdom")
  highway_data <- data$highways
  green_areas_data <- data$green_areas
  map <- nearest_greenspace(highway_data, green_areas_data, 51.4761, -0.2008, c("park", "forest"))
  print(map) # Display the map
}
}
