% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R, R/stress_function.R
\name{layout_igraph_centrality}
\alias{layout_igraph_centrality}
\alias{centrality_layout}
\alias{layout_with_centrality}
\title{Centrality layout}
\usage{
layout_igraph_centrality(g, cent, scale = T, iter = 500, tol = 1e-04,
  tseq = seq(0, 1, 0.2), circular)

layout_with_centrality(g, cent, scale = T, iter = 500, tol = 1e-04,
  tseq = seq(0, 1, 0.2))
}
\arguments{
\item{g}{igraph object}

\item{cent}{centrality scores}

\item{scale}{scale centrality between 0 and 100?}

\item{iter}{number of iterations}

\item{tol}{stopping criterion}

\item{tseq}{transition steps}

\item{circular}{not used}
}
\value{
coordinates to be used layouting a graph
}
\description{
arranges nodes in concentric circles according to a centrality index
}
\details{
the layout_igraph_* function should not be used directly. It is only used as an argument for 'ggraph'.
}
\examples{
library(igraph)
library(ggraph)
g <- sample_gnp(10,0.4)
ggraph(g,layout="centrality",cent=closeness(g))+
  draw_circle(use = "cent")+
  geom_edge_link()+
  geom_node_point(shape=21,fill="grey25",size=5)+
  theme_graph()+
  coord_fixed()
}
\references{
Brandes, U., & Pich, C. (2011). More flexible radial layout. Journal of Graph Algorithms and Applications, 15(1), 157-173.
}
