% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.GPPM}
\alias{predict.GPPM}
\title{GPPM predictions}
\usage{
\method{predict}{GPPM}(object, newData, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{newData}{a data frame with the same column names as the data frame used for generating \code{gpModel} with \code{\link{gppm}}. May only contain new data, that is, data that was not used for fitting.}

\item{...}{additional arguments (currently not used).}
}
\value{
Predictions of the dependent variable for all rows in newData. Conditional predictions for all persons in newData that are also present
in the data used for fitting gpModel; unconditional predictions for others persons.
See examples for format.
}
\description{
Obtain person-specific predictions.
}
\examples{
\donttest{
data("demoLGCM")
# remove all measurements from person 1 and the first form person 2
predIdx <- c(which(demoLGCM$ID == 1), which(demoLGCM$ID == 2)[1])
fitDemoLGCM <- demoLGCM[setdiff(1:nrow(demoLGCM), predIdx), ]

lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  fitDemoLGCM, "ID", "y"
)
lgcm <- fit(lgcm)
predRes <- predict(lgcm, demoLGCM[predIdx, ])
}
}
