% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gcs_metadata_object}
\alias{gcs_metadata_object}
\title{Make metadata for an object}
\usage{
gcs_metadata_object(object_name = NULL, metadata = NULL,
  md5Hash = NULL, crc32c = NULL, contentLanguage = NULL,
  contentEncoding = NULL, contentDisposition = NULL,
  cacheControl = NULL)
}
\arguments{
\item{object_name}{Name of the object. GCS uses this version if also set elsewhere, or a \code{gs://} URL}

\item{metadata}{User-provided metadata, in key/value pairs}

\item{md5Hash}{MD5 hash of the data; encoded using base64}

\item{crc32c}{CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order}

\item{contentLanguage}{Content-Language of the object data}

\item{contentEncoding}{Content-Encoding of the object data}

\item{contentDisposition}{Content-Disposition of the object data}

\item{cacheControl}{Cache-Control directive for the object data}
}
\value{
Object metadata for uploading of class \code{gar_Object}
}
\description{
Use this to pass to uploads in \link{gcs_upload}
}
\seealso{
Other object functions: \code{\link{gcs_compose_objects}},
  \code{\link{gcs_copy_object}},
  \code{\link{gcs_delete_object}},
  \code{\link{gcs_get_object}},
  \code{\link{gcs_list_objects}}
}
\concept{object functions}
