% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_secret}
\alias{cr_buildstep_secret}
\title{Create a buildstep for using Secret Manager}
\usage{
cr_buildstep_secret(
  secret,
  decrypted,
  version = "latest",
  binary_mode = FALSE,
  ...
)
}
\arguments{
\item{secret}{The secret data name in Secret Manager}

\item{decrypted}{The name of the file the secret will be decrypted into}

\item{version}{The version of the secret}

\item{binary_mode}{Should the file be treated in binary/raw format?}

\item{...}{Other arguments sent to \link{cr_buildstep_bash}}
}
\description{
This is the preferred way to manage secrets for files, rather than
  \link{cr_buildstep_decrypt}, as it stores the encrypted file in the cloud
  rather than in your project workspace.  For single environment values, \link{cr_build_yaml_secrets} may be more suitable.
}
\details{
This is for downloading encrypted files from Google Secret Manager.  You will need to add the
  Secret Accessor Cloud IAM role to the Cloud Build service account to use it.
Once you have uploaded your secret file and named it, it is available for Cloud
  Build to use.
}
\examples{
cr_buildstep_secret("my_secret", decrypted = "/workspace/secret.json")
}
\seealso{
How to set up secrets using \href{https://cloud.google.com/build/docs/securing-builds/use-secrets}{Secret Manager}

\link{cr_build_yaml_secrets} let you directly support environment arguments in the buildsteps

Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_packagetests}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep_targets}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
