% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{BuildTrigger}
\alias{BuildTrigger}
\title{BuildTrigger Object}
\usage{
BuildTrigger(
  filename = NULL,
  name = NULL,
  tags = NULL,
  build = NULL,
  ignoredFiles = NULL,
  github = NULL,
  substitutions = NULL,
  includedFiles = NULL,
  disabled = NULL,
  triggerTemplate = NULL,
  description = NULL
)
}
\arguments{
\item{filename}{Path, from the source root, to a file whose contents is used for the}

\item{name}{User assigned name of the trigger}

\item{tags}{Tags for annotation of a `BuildTrigger`}

\item{build}{Contents of the build template}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{github}{a \link{GitHubEventsConfig} object - mutually exclusive with \code{triggerTemplate}}

\item{substitutions}{A named list of Build macro variables}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{disabled}{If true, the trigger will never result in a build}

\item{triggerTemplate}{a \link{RepoSource} object - mutually exclusive with \code{github}}

\item{description}{Human-readable description of this trigger}
}
\value{
BuildTrigger object
}
\description{
Configuration for an automated build in response to source repositorychanges.
}
\seealso{
\url{https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.triggers}

Other BuildTrigger functions: 
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_make}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
