% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthlyComposite.R
\docType{methods}
\name{monthlyComposite}
\alias{monthlyComposite}
\alias{monthlyComposite,RasterStackBrick-method}
\alias{monthlyComposite,character-method}
\title{Calculate monthly composite images}
\usage{
\S4method{monthlyComposite}{RasterStackBrick}(x, indices, fun = max,
  cores = 1L, filename = "", ...)

\S4method{monthlyComposite}{character}(x, pos1 = 4L, pos2 = 8L, fun = max,
  cores = 1L, filename = "", ...)
}
\arguments{
\item{x}{'RasterStack' or 'character' vector of filenames. If the latter
applies and 'pos1', 'pos2' are not specified, the function will try to
retrieve monthly indices from \code{\link{monthlyIndices}}. Note that the
function does not work with binary data, but expects files that have
previously been created via \code{\link{rasterizeGimms}}.}

\item{indices}{'numeric'. Indices identifying layers or files from identical
months.}

\item{fun}{Function. Used to calculate monthly composite layers, defaults to
\code{max}.}

\item{cores}{Integer. Number of cores for parallel computing.}

\item{filename}{Character. Optional output filename(s); see
\code{\link{writeRaster}}. If \code{cores > 1}, the number of supplied
filenames must match up with the number of unique monthly indices.}

\item{...}{Further arguments passed on to \code{\link{writeRaster}}.}

\item{pos1, pos2}{Numeric. If 'x' is a vector of filenames, the first and last
element of the date string to build monthly indices from. Defaults to the
GIMMS naming convention, see \code{\link{monthlyIndices}}.}
}
\value{
A 'RasterStack' object with monthly composite layers.
}
\description{
Based on a user-defined function, e.g. \code{max} for maximum value
composites (MVC), aggregate bi-monthly GIMMS datasets to monthly composites.
}
\examples{
\dontrun{
## Download sample data
gimms_dir <- paste0(getwd(), "/data")

gimms_files <- downloadGimms(x = as.Date("2000-01-01"),
                             y = as.Date("2000-12-31"), dsn = gimms_dir)

## Rasterize files
gimms_raster <- rasterizeGimms(x = gimms_files, remove_header = TRUE)

## Create monthly maximum value composites
indices <- monthlyIndices(gimms_files)
gimms_raster_mvc <- monthlyComposite(gimms_raster, indices = indices)

## Visualize data
library(sp)
names(gimms_raster_mvc) <- paste(month.abb, 2000)
spplot(gimms_raster_mvc)
}

}
\author{
Florian Detsch
}
\seealso{
\code{\link{stackApply}}, \code{\link{monthlyIndices}},
\code{\link{writeRaster}}.
}

