% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthlyComposite.R
\docType{methods}
\name{monthlyComposite}
\alias{monthlyComposite}
\alias{monthlyComposite,RasterStack-method}
\alias{monthlyComposite,character-method}
\title{Calculate monthly composite images}
\usage{
\S4method{monthlyComposite}{RasterStack}(x, indices, fun = max, ...)

\S4method{monthlyComposite}{character}(x, pos1 = 4L, pos2 = 8L, fun = max,
  ...)
}
\arguments{
\item{x}{RasterStack (requires 'indices') or character vector of filenames.
If the latter applies and 'pos1', 'pos2' are not specified, the function will
try to retrieve monthly indices from \code{\link{monthlyIndices}}. Note that
the function does not work with binary data, but expects files that have
previously been created via \code{\link{rasterizeGimms}}.}

\item{indices}{Numeric. Indices indicating RasterLayers or files from
identical months; see \code{\link{stackApply}}.}

\item{fun}{Function. Used to calculate monthly composite layers, defaults to
\code{sum}, i.e. MVC; see \code{\link{stackApply}}.}

\item{...}{Further arguments passed on to \code{\link{writeRaster}}.}

\item{pos1, pos2}{Numeric. If 'x' is a vector of filenames, the first and last
element of the date string to build monthly indices from. Defaults to the
GIMMS naming convention; see \code{\link{monthlyIndices}} and
\code{\link{substr}}.}
}
\value{
A 'RasterStack' object with monthly composite layers.
}
\description{
Based on a user-defined function, e.g. \code{max} for maximum value
composites (MVC), aggregate bi-monthly GIMMS datasets to monthly composites.
}
\examples{
\dontrun{
## Destination folder for data download
gimms_dir <- paste0(getwd(), "/data")

## Download GIMMS NDVI3g binary data from 2000-2005
gimms_files <- downloadGimms(x = 2000, y = 2005, dsn = gimms_dir)

## Rasterize downloaded GIMMS files from 2000
gimms_raster <- rasterizeGimms(x = gimms_files[1:24], remove_header = TRUE)

## Calculate monthly maximum value composites
indices <- monthlyIndices(gimms_files[1:24])
gimms_raster_mvc <- monthlyComposite(gimms_raster, indices = indices)

plot(gimms_raster_mvc[[1:4]])
}

}
\author{
Florian Detsch
}
\seealso{
\code{\link{stackApply}}, \code{\link{monthlyIndices}}.
}

