% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{print.VarCorr.galamm}
\alias{print.VarCorr.galamm}
\title{Print method for variance-covariance objects}
\usage{
\method{print}{VarCorr.galamm}(
  x,
  digits = max(3, getOption("digits") - 2),
  comp = c("Std.Dev.", "Variance"),
  corr = any(comp == "Std.Dev."),
  ...
)
}
\arguments{
\item{x}{An object of class \code{c("VarCorr.galamm", "VarCorr.merMod")},
returned from \code{\link{VarCorr.galamm}}.}

\item{digits}{Optional arguments specifying number of digits to use when
printing.}

\item{comp}{Character vector of length 1 or 2 specifying which variance
components to print. Case sensitive. Can take one of the values "Std.Dev."
and "Variance".}

\item{corr}{Logical value indicating whether covariances or correlations
should be printed.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
The variance-covariance information is printed to the console and the
argument \code{x} is silently returned.
}
\description{
Print method for variance-covariance objects
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  dispformula = ~ (1 | item),
  data = hsced
)

# Extract information on variance and covariance
VarCorr(mod)

}
\references{
\insertRef{batesFittingLinearMixedEffects2015}{galamm}
}
\seealso{
\code{\link[=VarCorr.galamm]{VarCorr.galamm()}} for the function creating the variance-covariance
objects.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\author{
This function is derived from \code{lme4:::print.VarCorr.merMod}
written by Douglas M. Bates, Martin Maechler, Ben Bolker, and Steve Walker.
}
\concept{details of model fit}
