% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.galamm.R
\name{summary.galamm}
\alias{summary.galamm}
\title{Summarizing GALAMM fits}
\usage{
\method{summary}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Further arguments passed on to other methods. Currently not used.}
}
\value{
A list of summary statistics of the fitted model of class
\code{summary.galamm}, containing the following elements:
\itemize{
\item \code{AICtab} a table of model fit measures, returned by
\code{\link{llikAIC}}.
\item \code{call} the matched call used when fitting the model.
\item \code{fixef} a matrix with fixed effect estimated, returned by
\code{\link{fixef}}.
\item \code{gam} List containing information about smooth terms in the model. If
no smooth terms are contained in the model, then it is a list of length
zero.
\item \code{model} a list with various elements related to the model setup and
fit. See \code{?galamm} for details.
\item \code{parameters} A list object with model parameters and related
information. See \code{?galamm} for details.
\item \code{Lambda} An object containing the estimated factor loadings. Returned
from \code{\link{factor_loadings.galamm}}. If there are no estimated factor
loadings, then this object is \code{NULL}.
\item \code{random_effects} a list containing the random effects.
See \code{?galamm} for details.
\item \code{VarCorr} An object of class \code{VarCorr.galamm}, returned from
\code{\link{VarCorr.galamm}}.
\item \code{weights} An object containing information about estimated variance
functions, when there are heteroscedastic residuals. Otherwise the object
is \code{NULL}.
}
}
\description{
Summary method for class "galamm".
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

summary(mod)

}
\seealso{
\code{\link[=print.summary.galamm]{print.summary.galamm()}} for the print method and \code{\link[=summary]{summary()}} for
the generic.

Other summary functions: 
\code{\link{anova.galamm}()},
\code{\link{plot.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.galamm}()},
\code{\link{print.summary.galamm}()}
}
\author{
Some of the code for producing summary information has been derived
from the summary methods of \code{mgcv} (author: Simon Wood) and
\code{lme4} \insertCite{batesFittingLinearMixedEffects2015}{galamm}
(authors: Douglas M. Bates, Martin Maechler, Ben Bolker, and Steve Walker).
}
\concept{summary functions}
