% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality_kappamax.R
\name{flux_quality_kappamax}
\alias{flux_quality_kappamax}
\title{selecting linear slope with kappamax method}
\usage{
flux_quality_kappamax(
  slopes_df,
  f_slope,
  f_fit,
  f_fluxid,
  f_slope_lm,
  f_fit_lm,
  f_b,
  force_exp,
  fit_type,
  instr_error,
  name_df
)
}
\arguments{
\item{slopes_df}{dataset containing slopes}

\item{f_slope}{column containing the slope of each flux
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{f_fit}{column containing the modeled data (exponential fits)}

\item{f_fluxid}{column of ID for each measurement}

\item{f_slope_lm}{column containing the linear slope of each flux}

\item{f_fit_lm}{column with the fit of the linear model.}

\item{f_b}{column containing the b parameter of the exponential expression}

\item{force_exp}{vector of fluxIDs for which the exponential slope should be
used by the user's decision (kappamax method)}

\item{fit_type}{model fitted to the data, linear, quadratic or exponential.
Will be automatically filled if \code{slopes_df} was produced using
\link[fluxible:flux_fitting]{flux_fitting}}

\item{instr_error}{error of the instrument, in the same unit as the
gas concentration}

\item{name_df}{name of \code{slopes_df}}
}
\description{
selecting linear slope with kappamax method
}
\keyword{internal}
