% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fanova.RPm.R, R/summary.anova.R
\name{fanova.RPm}
\alias{fanova.RPm}
\alias{summary.fanova.RPm}
\title{Functional ANOVA with Random Project.}
\usage{
fanova.RPm(object, formula, data.fac, RP = min(30, ncol(object)),
  alpha = 0.95, zproj = NULL, par.zproj = list(norm = TRUE),
  hetero = TRUE, pr = FALSE, w = rep(1, ncol(object)), nboot = 0,
  contrast = NULL, ...)

\method{summary}{fanova.RPm}(object, ndec = NULL, ...)
}
\arguments{
\item{object}{Functional response data.  Object with class fdata with
\code{n} curves discretizated in \code{m} points. For multivariate problems
\code{object} can be a \code{data.frame} or a \code{matrix}}

\item{formula}{as \link[stats]{formula} without response.}

\item{data.fac}{Explanatory variables.  Data frame with dimension (\code{n}
x \code{p}), where \code{p} are the number of factors or covariates
considered.}

\item{RP}{Vector of number of random projections.}

\item{alpha}{Alpha value, by defalult \code{alpha}=0.95.}

\item{zproj}{Function for generating the projections or an object that
contains that projections.}

\item{par.zproj}{List of parameters for \code{zproj} function.}

\item{hetero}{\code{logical}. If \code{TRUE} (by default) means heteroskedastic ANOVA.}

\item{pr}{code{logical}. If \code{TRUE} prints intermediate results.}

\item{w}{Vector of weights (only for multivariate problems).}

\item{nboot}{Number of bootstrap samples, by default no bootstrap
computations, \code{nboot}=0.}

\item{contrast}{List of special contrast to be used ; by default no special
contrasts are used (\code{contrast}=\code{NULL}).}

\item{\dots}{Further arguments passed to or from other methods.}

\item{ndec}{Number of decimals.}
}
\value{
An object with the following components:\cr 
\itemize{
\item {proj}{ The projection value of each point on the curves. Matrix with dimension
(\code{RP} x \code{m}), where \code{RP} is the number of projection and
\code{m} are the points observed in each projection curve.} 
\item {mins}{
minimum number for each random projection.} 
\item {result}{ p-value for each
random projection.} 
\item {test.Bonf}{ significance (TRUE or FALSE) for
vector of random projections \code{RP} in columns and factor (and special
contrast) by rows.} 
\item {p.Bonf}{ p-value for vector of random projections
\code{RP} in columns and factor (and special contrast) by rows.}
\item {test.fdr}{ False Discovery Rate (TRUE or FALSE) for vector of random
projections \code{RP} in columns and factor (and special contrast) by rows.}
\item {p.fdr}{ p-value of False Discovery Rate for vector of random
projections \code{RP} in columns and factor (and special contrast) by rows.}
\item {test.Boot}{ False Discovery Rate (TRUE or FALSE) for vector of random
projections \code{RP} in columns and factor (and special contrast) by rows.}
\item {p.Boot}{ p-value of Bootstrap sambple for vector of random projections
\code{RP} in columns and factor (and special contrast) by rows.}
}
}
\description{
The procedure is based on the analysis of randomly chosen one-dimensional
projections. The function tests ANOVA models for functional data with
continuous covariates and perform special contrasts for the factors in the
formula.
}
\details{
\code{zproj} allows to change the generator process of the projections. This
can be done through the inclusion of a function or a collection of
projections generated outside the function. By default, for a functional
problem, the function \code{\link{rproc2fdata}} is used. For multivariate problems,
if no function is included, the projections are generated by a normalized
gaussian process of the same dimension as \code{object}. Any user function
can be included with the only limitation that the two first parameters are:
\itemize{
\item \code{n}: number of projections
\item \code{t}: discretization points for functional problems
\item \code{m}: number of columns for multivariate problems.
}
That functions must return a \code{fdata} or \code{matrix} object
respectively.  

The function allows user-defined contrasts.  The list of contrast to be used
for some of the factors in the formula.  Each contrast matrix in the list
has \code{r} rows, where \code{r} is the number of factor levels. The user
can also request special predetermined contrasts, for example using the
\code{\link{contr.helmert}}, \code{\link{contr.sum}} or
\code{\link{contr.treatment}} functions.
 
The function returns (by default) the significance of the variables using
the Bonferroni test and the False Discovery Rate test. Bootstrap procedure
provides more precision
}
\note{
anova.RPm deprecated.

If \code{hetero=TRUE} then all factors must be categorical.
}
\examples{
\dontrun{
# ex fanova.hetero
data(phoneme)
names(phoneme)
# A MV matrix obtained from functional data
data=as.data.frame(phoneme$learn$data[,c(1,seq(0,150,10)[-1])]) 
group=phoneme$classlearn
n=nrow(data)
group.rand=as.factor(sample(rep(1:3,len=n),n))
RP=c(2,5,15,30)

#ex 1: real factor and random factor
m03=data.frame(group,group.rand)
resul1=fanova.RPm(phoneme$learn,~group+group.rand,m03,RP=c(5,30))
summary(resul1)

#ex 2: real factor with special contrast
m0=data.frame(group)
cr5=contr.sum(5)   #each level vs last level
resul03c1=fanova.RPm(data,~group,m0,contrast=list(group=cr5))
summary(resul03c1)

#ex 3: random factor with special contrast. Same projs as ex 2.
m0=data.frame(group.rand)
zz=resul03c1$proj
cr3=contr.sum(3)   #each level vs last level
resul03c1=fanova.RPm(data,~group.rand,m0,contrast=list(group.rand=cr3),zproj=zz)
summary(resul03c1)
}
  
}
\references{
Cuesta-Albertos, J.A., Febrero-Bande, M. \emph{A simple multiway
ANOVA for functional data.} TEST 2010, DOI \bold{10.1007/s11749-010-0185-3}.
}
\seealso{
See Also as: \code{\link{fanova.onefactor}}
}
\author{
Juan A. Cuesta-Albertos, Manuel Febrero-Bande, Manuel Oviedo de la
Fuente\cr \email{manuel.oviedo@usc.es}
}
\keyword{anova}
