% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{l2_reg}
\alias{l2_reg}
\title{L2_reg}
\usage{
l2_reg(p, lr, wd, do_wd = TRUE, ...)
}
\arguments{
\item{p}{p}

\item{lr}{learning rate}

\item{wd}{weight decay}

\item{do_wd}{do_wd}

\item{...}{additional arguments to pass}
}
\value{
None
}
\description{
L2 regularization as adding `wd*p` to `p$grad`
}
\examples{

\dontrun{

tst_param = function(val, grad = NULL) {
  "Create a tensor with `val` and a gradient of `grad` for testing"
  res = tensor(val) \%>\% float()

  if(is.null(grad)) {
    grad = tensor(val / 10)
  } else {
    grad = tensor(grad)
  }

  res$grad = grad \%>\% float()
  res
}
p = tst_param(1., 0.1)
l2_reg(p, 1., 0.1)

}

}
