% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDocs.R
\docType{data}
\name{pisa2012}
\alias{pisa2012}
\title{PISA 2012 dataset}
\usage{
data(pisa2012)
}
\description{
Data from the \code{PISA2012lite} package.
}
\details{
The original dataset (Program for International Student Assesment, \url{http://www.oecd.org/pisa/}) contains information on students'
performance on various cognitive tests expressed with so-called plausible values measured in three fields: Mathematics (\code{PV1MATH}),
Science (\code{PV1SCIE}) and Reading (\code{PV1READ}).

\code{pisa2012} is a reweighted version of the \code{PISA2012lite} data. The weighting was performed using the \code{W_FSTUWT} variable.

The variables are as follows (original column names from the \code{PISA2012lite} package are given in brackets):

\itemize{
  \item \code{math} -- student's performance in Mathematics (originally: PV1MATH)
  \item \code{reading} -- student's performance in Reading (originally: PV1READ)
  \item \code{science} -- student's performance in Science (originally: PV1SCIE)
  \item \code{country} -- student's country (originally: CNT)
}
}
\keyword{data}
