% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{attrcov-ergmTerm}
\alias{attrcov-ergmTerm}
\alias{InitErgmTerm.attrcov}
\alias{InitWtErgmTerm.attrcov}
\title{Edge covariate by attribute pairing}
\usage{
# binary: attrcov(attr, mat)

# valued: attrcov(attr, mat, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{mat}{a matrix of covariates with the same dimensions as a mixing matrix for \code{attr}}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
This term adds one statistic to the model, equal to the sum of the covariate values
for each edge appearing in the network, where the covariate value for a given edge is determined by its mixing type on
\code{attr}. Undirected networks are regarded as having undirected mixing, and it is assumed that \code{mat} is symmetric
in that case.

This term can be useful for simulating large networks with many mixing types, where \code{nodemix} would be slow due to
the large number of statistics, and \code{edgecov} cannot be used because an adjacency matrix would be too big.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "attrcov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
