% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.san.R
\name{ergm_SAN_slave}
\alias{ergm_SAN_slave}
\title{Internal Function to Perform Simulated Annealing}
\usage{
ergm_SAN_slave(
  state,
  tau,
  control,
  verbose,
  ...,
  nsteps = NULL,
  samplesize = NULL,
  statindices = NULL,
  offsetindices = NULL,
  offsets = NULL
)
}
\arguments{
\item{state}{an \code{\link{ergm_state}} representing the sampler state, containing information about the network, the model, the proposal, and current statistics.}

\item{tau}{a scalar; temperature to use; higher temperature means more proposals that "worsen" the statistics are accepted.}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.san]{control.san()}}. Its documentation
gives the the list of recognized control parameters and their
meaning. The more generic utility \code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL)
also provides argument completion for the available control
functions and limited argument name checking.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{...}{additional arguments, currently unused.}

\item{nsteps}{an integer; number of SAN proposals.}

\item{samplesize}{an integer; number of network statistics to return.}

\item{statindices, offsetindices, offsets}{specification for offset handling; see \code{\link[=san.formula]{san.formula()}} implementation.}
}
\description{
This is an internal function, not normally called directly by the
user. The \code{ergm_SAN_slave} function samples networks and
network statistics using a simulated annealing (SAN) algorithm via
\code{SAN_wrapper}.
}
\keyword{internal}
