% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{diff-ergmTerm}
\alias{diff-ergmTerm}
\alias{InitErgmTerm.diff}
\alias{InitWtErgmTerm.diff}
\title{Difference}
\usage{
# binary: diff(attr, pow=1, dir="t-h", sign.action="identity")

# valued: diff(attr, pow=1, dir="t-h", sign.action="identity", form ="sum")
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{pow}{exponent for the node difference}

\item{dir}{determines which vertix's attribute is subtracted from which. Accepts: \code{"t-h"} (the default), \code{"tail-head"} , \code{"b1-b2"}, \code{"h-t"} , \code{"head-tail"} , and \code{"b2-b1"} .}

\item{sign.action}{one of \code{"identity"}, \code{"abs"}, \code{"posonly"}, \code{"negonly"}. The following \code{sign.actions} are possible:
\itemize{
\item \code{"identity"} (the default) no transformation of the
difference regardless of sign
\item \code{"abs"} absolute value of the difference: equivalent
to the absdiff term
\item \code{"posonly"} positive differences are kept, negative
differences are replaced by 0
\item \code{"negonly"} negative differences are kept, positive
differences are replaced by 0
}}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
For values of \code{pow} other than
\code{0} , this term adds one network statistic to the model,
equaling the sum, over directed edges \eqn{(i,j)} , of
\code{sign.action(attr[i]-attr[j])^pow} if \code{dir} is
\code{"t-h"} and of \code{sign.action(attr[j]-attr[i])^pow} if
\code{"h-t"} . That is, the
argument \code{dir} determines which vertex's attribute is
subtracted from which, with tail being the origin of a directed edge
and head being its destination, and bipartite networks' edges being
treated as going from the first part (b1) to the second (b2).

If \code{pow==0} , the exponentiation is replaced by the signum
function: \code{+1} if the difference is positive, \code{0} if there
is no difference, and \code{-1} if the difference is negative. Note
that this function is applied after the
\code{sign.action} . The comparison is exact, so when using
calculated values of \code{attr} , ensure that values that you
want to be considered equal are, in fact, equal.
}
\note{
this term may not be meaningful for unipartite undirected
networks unless \code{sign.action=="abs"} . When used on such a
network, it behaves as if all edges were directed, going from the
lower-indexed vertex to the higher-indexed vertex.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{bipartite}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{quantitative nodal attribute}
\concept{undirected}
