% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2degree-ergmTerm}
\alias{b2degree-ergmTerm}
\alias{InitErgmTerm.b2degree}
\title{Degree for the second mode in a bipartite network}
\usage{
# binary: b2degree(d, by=NULL)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{by}{this optional term specifies
a vertex attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details). If this is specified
then each node's degree is tabulated only with other nodes having the same
value of the \code{by} attribute.}
}
\description{
This term adds one network statistic to the model for
each element in \code{d} ; the \eqn{i} th such statistic equals the number of
nodes of degree \code{d[i]} in the second mode of a bipartite network, i.e.
with exactly \code{d[i]} edges. The second mode of a bipartite network
object is sometimes known as the "event" mode.
}
\note{
This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{frequently-used}
\concept{undirected}
