% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.bridge.R
\name{ergm.bridge.llr}
\alias{ergm.bridge.llr}
\alias{ergm.bridge.0.llk}
\alias{ergm.bridge.dindstart.llk}
\title{Bridge sampling to evaluate ERGM log-likelihoods and log-likelihood ratios}
\usage{
ergm.bridge.llr(object, response = NULL, constraints = ~., from, to,
  basis = NULL, verbose = FALSE, ..., llronly = FALSE,
  control = control.ergm.bridge())

ergm.bridge.0.llk(object, response = response, constraints = ~., coef,
  ..., llkonly = TRUE, control = control.ergm.bridge())

ergm.bridge.dindstart.llk(object, response = NULL, constraints = ~.,
  coef, dind = NULL, coef.dind = NULL, basis = NULL, ...,
  llkonly = TRUE, control = control.ergm.bridge())
}
\arguments{
\item{object}{A model formula. See \code{\link{ergm}} for details.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{constraints}{A one-sided formula specifying one or more
constraints on the support of the distribution of the networks
being simulated. See the documentation for a similar argument for
\code{\link{ergm}} for more information.}

\item{from, to}{The initial and final parameter vectors.}

\item{basis}{An optional \code{\link[network]{network}} object to
start the Markov chain.  If omitted, the default is the
left-hand-side of the \code{object}.}

\item{verbose}{Logical: If TRUE, print detailed information.}

\item{\dots}{Further arguments to \code{ergm.bridge.llr} and
\code{\link{simulate.formula.ergm}}.}

\item{llronly}{Logical: If TRUE, only the estiamted log-ratio will
be returned by \code{ergm.bridge.llr}.}

\item{control}{Control arguments.  See
\code{\link{control.ergm.bridge}} for details.}

\item{coef}{A vector of coefficients for the configuration of
interest.}

\item{llkonly}{Whether only the estiamted log-likelihood should be
returned by the \code{ergm.bridge.0.llk} and
\code{ergm.bridge.dindstart.llk}.  (Defaults to TRUE.)}

\item{dind}{A one-sided formula with the dyad-independent model to use as a
starting point. Defaults to the dyad-independent terms found in the formula
\code{object} with an overal density term (\code{edges}) added if not
redundant.}

\item{coef.dind}{Parameter configuration for the dyad-independent starting
point. Defaults to the MLE of \code{dind}.}
}
\value{
If \code{llronly=TRUE} or \code{llkonly=TRUE}, these functions return
the scalar log-likelihood-ratio or the log-likelihood.
Otherwise, they return a list with the following components:
\item{llr}{The estimated log-ratio.}  \item{llrs}{The estimated
log-ratios for each of the \code{nsteps} bridges.}  \item{path}{A
numeric matrix with nsteps rows, with each row being the
respective bridge's parameter configuration.}  \item{stats}{A
numeric matrix with nsteps rows, with each row being the
respective bridge's vector of simulated statistics.}
\item{Dtheta.Du}{The gradient vector of the parameter values with
respect to position of the bridge.}

\code{ergm.bridge.0.llk} result list also includes an \code{llk}
element, with the log-likelihood itself (with the reference
distribution assumed to have likelihood 0).

\code{ergm.bridge.dindstart.llk} result list also includes
an \code{llk} element, with the log-likelihood itself and an
\code{llk.dind} element, with the log-likelihood of the nearest
dyad-independent model.
}
\description{
\code{ergm.bridge.llr} uses bridge sampling with geometric spacing to
estimate the difference between the log-likelihoods of two parameter vectors
for an ERGM via repeated calls to \code{\link{simulate.formula.ergm}}.

\code{ergm.bridge.0.llk} is a convenience wrapper that
returns the log-likelihood of configuration \eqn{\theta}
\emph{relative to the reference measure}. That is, the
configuration with \eqn{\theta=0} is defined as having log-likelihood of
0.

\code{ergm.bridge.dindstart.llk} is a wrapper that uses a
dyad-independent ERGM as a starting point for bridge sampling to
estimate the log-likelihood for a given dyad-dependent model and
parameter configuration.  Note that it only handles binary ERGMs
(\code{response=NULL}) and with constraints (\code{constraints=}) that that
do not induce dyadic dependence.
}
\references{
Hunter, D. R. and Handcock, M. S. (2006)
\emph{Inference in curved exponential family models for
networks}, Journal of Computational and Graphical Statistics.
}
\seealso{
\code{\link{simulate.formula.ergm}}
}
\keyword{model}
