% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.hotelling.diff.test.R
\name{spectrum0.mvar}
\alias{spectrum0.mvar}
\title{Multivariate version of \code{coda}'s \code{\link[=spectrum0.ar]{spectrum0.ar()}}.}
\usage{
spectrum0.mvar(x, order.max = NULL, aic = is.null(order.max),
  tol = .Machine$double.eps^0.5, ...)
}
\arguments{
\item{x}{a matrix with observations in rows and variables in
columns.}

\item{order.max}{maximum (or fixed) order for the AR model.}

\item{aic}{use AIC to select the order (up to \code{order.max}).}

\item{tol}{drop components until the reciprocal condition number of
the transformed variance-covariance matrix is greater than this.}

\item{...}{additional arguments to \code{\link[=ar]{ar()}}.}
}
\description{
Its return value, divided by \code{nrow(cbind(x))}, is the estimated
variance-covariance matrix of the sampling distribution of the mean
of \code{x} if \code{x} is a multivatriate time series with AR(\eqn{p}) structure, with
\eqn{p} determined by AIC.
}
\note{
\code{\link[=ar]{ar()}} fails if \code{crossprod(x)} is singular,
which is remedied by mapping the variables onto the principal
components of \code{x}, dropping redundant dimentions.
}
