% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as_alts_df}
\alias{as_alts_df}
\alias{as_aaties_df}
\title{Create global alters and alter-alter relations dataframes from an \code{egor} object}
\usage{
as_alts_df(object, egoID = "egoID", include.ego.vars = FALSE)

as_aaties_df(object, egoID = "egoID", include.ego.vars = FALSE,
  include.alt.vars = FALSE, aatie_vars = c(".srcID", ".tgtID"))
}
\arguments{
\item{object}{An \code{egor} object.}

\item{egoID}{Character, naming the variable used to identify egos. If this variable does not exist,
a new variable with the specified name is created.}

\item{include.ego.vars}{Logical, specifying if ego variables should be included in the result.}

\item{include.alt.vars}{Logical, specifying if alter variables should be included in the result.}

\item{aatie_vars}{Character vector, specifying the names of the source and target columns.}
}
\description{
Provided an egor-object, these functions create a 'global' \code{data.frame},
containing alter attributes, or alter-alter relations. The resulting dataframes
are useful for advanced analysis procedures, e.g. multi-level regressions.
}
\examples{
# Load example data
data(egor32)

# Create global alters dataframes
as_alts_df(egor32)

# Create global alter-alter relaions dataframes
as_aaties_df(egor32)

# ... adding alter variables
as_aaties_df(egor32, include.alt.vars = TRUE)
}
