% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scompvar.R
\name{scompvar}
\alias{scompvar}
\alias{compvar}
\title{Simulated Components of Variation}
\usage{
scompvar(data, n = NULL, m = NULL)
}
\arguments{
\item{data}{Object of class \code{"ecocbo_data"} obtained from \code{\link[=prep_data]{prep_data()}}.}

\item{n}{Optional. Integer. Number of samples to consider.}

\item{m}{Optional. Integer. Number of replicates to consider.}
}
\value{
A data frame containing the values for the variation component
among sites \code{compVarA} and in the residuals \code{compVarR}.
}
\description{
Computes the average components of variation among sampling units and within
samples in relation to sampling effort.
}
\details{
If \code{m} or \code{n} are set to \code{NULL}, the function automatically uses the
largest available values from the experimental design set in \code{\link[=sim_beta]{sim_beta()}}.
}
\examples{
scompvar(data = simResults)
scompvar(data = simResults, n = 5, m = 2)

}
\references{
\itemize{
\item Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
\item Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=prep_data]{prep_data()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
