% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_DB_infos.R
\name{dbKeys}
\alias{dbKeys}
\title{Get keys from a relational data base.}
\usage{
dbKeys(filePath, includeMeta = FALSE)
}
\arguments{
\item{filePath}{Path of the existing db file.}

\item{includeMeta}{Should information about the \code{Meta_Data} table be included.}
}
\value{
Returns a list named as the data tables in the db. Each elements contains a list with the primary key, the
data table it references to and the corresponding foreign keys.
}
\description{
Function to get the primary and foreign keys of the data frames in the relational data base.
}
\details{
Data in a relational data base are indexed by primary and foreign keys. Primary keys are unique identifiers
inside a single data table. Foreign keys reference (link) to other data tables. This function returns the
key structure of a relational data base.
}
\examples{
db_path <- system.file("extdata", "example_dataBase.db", package = "eatDB")
keys <- dbKeys(db_path)

## primary key structure of the database
keys$pkList

## foreign key structure of the database
keys$fkList

}
