% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPoisson.R
\name{dzipois}
\alias{dzipois}
\alias{pzipois}
\alias{qzipois}
\alias{rzipois}
\title{The zero-inflated Poisson distribution}
\usage{
dzipois(x, lambda, pi, log = FALSE)

pzipois(q, lambda, pi, lower.tail = TRUE, log.p = FALSE)

qzipois(p, lambda, pi, lower.tail = TRUE, log.p = FALSE)

rzipois(n, lambda, pi)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{lambda}{vector of (non-negative) Poisson parameters.}

\item{pi}{vector of zero-inflation probabilities in the unit interval.}

\item{log, log.p}{logical indicating whether probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical indicating whether probabilities are \eqn{P[X \le x]} (lower tail) or \eqn{P[X > x]} (upper tail).}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\description{
Density, distribution function, quantile function, and random
generation for the zero-inflated Poisson distribution with
parameters \code{lambda} and \code{pi}.
}
\details{
All functions follow the usual conventions of d/p/q/r functions
in base R. In particular, all four \code{zipois} functions for the
zero-inflated Poisson distribution call the corresponding \code{pois}
functions for the Poisson distribution from base R internally.

Note, however, that the precision of \code{qzipois} for very large
probabilities (close to 1) is limited because the probabilities
are internally handled in levels and not in logs (even if \code{log.p = TRUE}).
}
\examples{
## theoretical probabilities for a zero-inflated Poisson distribution
x <- 0:8
p <- dzipois(x, lambda = 2.5, pi = 0.25)
plot(x, p, type = "h", lwd = 2)

## corresponding empirical frequencies from a simulated sample
set.seed(0)
y <- rzipois(500, lambda = 2.5, pi = 0.25)
hist(y, breaks = -1:max(y) + 0.5)

}
\seealso{
\code{\link{ZIPoisson}}, \code{\link{dpois}}
}
\keyword{distribution}
