% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdleNegativeBinomial.R
\name{dhnbinom}
\alias{dhnbinom}
\alias{phnbinom}
\alias{qhnbinom}
\alias{rhnbinom}
\title{The hurdle negative binomial distribution}
\usage{
dhnbinom(x, mu, theta, size, pi, log = FALSE)

phnbinom(q, mu, theta, size, pi, lower.tail = TRUE, log.p = FALSE)

qhnbinom(p, mu, theta, size, pi, lower.tail = TRUE, log.p = FALSE)

rhnbinom(n, mu, theta, size, pi)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{mu}{vector of (non-negative) negative binomial location parameters.}

\item{theta, size}{vector of (non-negative) negative binomial overdispersion parameters.
Only \code{theta} or, equivalently, \code{size} may be specified.}

\item{pi}{vector of zero-hurdle probabilities in the unit interval.}

\item{log, log.p}{logical indicating whether probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical indicating whether probabilities are \eqn{P[X \le x]} (lower tail) or \eqn{P[X > x]} (upper tail).}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\description{
Density, distribution function, quantile function, and random
generation for the zero-hurdle negative binomial distribution with
parameters \code{mu}, \code{theta} (or \code{size}), and \code{pi}.
}
\details{
All functions follow the usual conventions of d/p/q/r functions
in base R. In particular, all four \code{hnbinom} functions for the
hurdle negative binomial distribution call the corresponding \code{nbinom}
functions for the negative binomial distribution from base R internally.

Note, however, that the precision of \code{qhnbinom} for very large
probabilities (close to 1) is limited because the probabilities
are internally handled in levels and not in logs (even if \code{log.p = TRUE}).
}
\examples{
## theoretical probabilities for a hurdle negative binomial distribution
x <- 0:8
p <- dhnbinom(x, mu = 2.5, theta = 1, pi = 0.75)
plot(x, p, type = "h", lwd = 2)

## corresponding empirical frequencies from a simulated sample
set.seed(0)
y <- rhnbinom(500, mu = 2.5, theta = 1, pi = 0.75)
hist(y, breaks = -1:max(y) + 0.5)

}
\seealso{
\code{\link{HurdleNegativeBinomial}}, \code{\link{dnbinom}}
}
\keyword{distribution}
