% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffeqr.R
\name{diffeqgpu_setup}
\alias{diffeqgpu_setup}
\title{Setup DiffEqGPU}
\usage{
diffeqgpu_setup(backend)
}
\arguments{
\item{backend}{the backend for the GPU computation. Choices are "CUDA", "AMDGPU", "Metal", or "oneAPI"}
}
\description{
This function initializes the DiffEqGPU package for GPU-parallelized ensembles.
The first time will be long since it includes precompilation.
}
\value{
 Returns a degpu object which holds the module state of the Julia-side DiffEqGPU
 package. The core use is to use degpu$EnsembleGPUKernel() for choosing the GPU
 dispatch in the solve.
}
\examples{

\dontrun{ ## diffeqgpu_setup() is time-consuming and requires Julia+DifferentialEquations.jl

degpu <- diffeqr::diffeqgpu_setup(backend)

}

}
