% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_separate.R
\name{data_separate}
\alias{data_separate}
\title{Separate single variable into multiple variables}
\usage{
data_separate(
  data,
  select = NULL,
  new_columns = NULL,
  separator = "[^[:alnum:]]+",
  guess_columns = NULL,
  merge_multiple = FALSE,
  merge_separator = "",
  fill = "right",
  extra = "drop_right",
  convert_na = TRUE,
  exclude = NULL,
  append = FALSE,
  ignore_case = FALSE,
  verbose = TRUE,
  regex = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-(Sepal.Width:Petal.Length)}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{extract_column_names(iris, select = c("Species", "Test"))}
will just return \code{"Species"}.}

\item{new_columns}{The names of the new columns, as character vector. If
more than one variable was selected (in \code{select}), the new names are prefixed
with the name of the original column. \code{new_columns} can also be a list of
(named) character vectors when multiple variables should be separated. See
'Examples'.}

\item{separator}{Separator between columns. Can be a character vector, which
is then treated as regular expression, or a numeric vector that indicates at
which positions the string values will be split.}

\item{guess_columns}{If \code{new_columns} is not given, the required number of
new columns is guessed based on the results of value splitting. For example,
if a variable is split into three new columns, this will be considered as
the required number of new columns, and columns are named \code{"split_1"},
\code{"split_2"} and \code{"split_3"}. When values from a variable are split into
different amount of new columns, the \code{guess_column} can be either \code{"mode"}
(number of new columns is based on the most common number of splits), \code{"min"}
or \code{"max"} to use the minimum resp. maximum number of possible splits as
required number of columns.}

\item{merge_multiple}{Logical, if \code{TRUE} and more than one variable is selected
for separating, new columns can be merged. Value pairs of all split variables
are merged.}

\item{merge_separator}{Separator string when \code{merge_multiple = TRUE}. Defines
the string that is used to merge values together.}

\item{fill}{How to deal with values that return fewer new columns after
splitting? Can be \code{"left"} (fill missing columns from the left with \code{NA}),
\code{"right"} (fill missing columns from the right with \code{NA}) or \code{"value_left"}
or \code{"value_right"} to fill missing columns from left or right with the
left-most or right-most values.}

\item{extra}{How to deal with values that return too many new columns after
splitting? Can be \code{"drop_left"} or \code{"drop_right"} to drop the left-most or
right-most values, or \code{"merge_left"} or \code{"merge_right"} to merge the left-
or right-most value together, and keeping all remaining values as is.}

\item{convert_na}{Logical, if \code{TRUE}, character \code{"NA"} values are converted
into real \code{NA} values.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{append}{Logical, if \code{FALSE} (default), removes original columns that
were separated. If \code{TRUE}, all columns are preserved and the new columns are
appended to the data frame.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{verbose}{Toggle warnings.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}

\item{...}{Currently not used.}
}
\value{
A data frame with the newly created variable(s), or - when \code{append = TRUE} -
\code{data} including new variables.
}
\description{
Separates a single variable into multiple new variables.
}
\examples{
# simple case
d <- data.frame(
  x = c("1.a.6", "2.b.7", "3.c.8"),
  stringsAsFactors = FALSE
)
d
data_separate(d, new_columns = c("a", "b", "c"))

# guess number of columns
d <- data.frame(
  x = c("1.a.6", NA, "2.b.6.7", "3.c", "x.y.z"),
  stringsAsFactors = FALSE
)
d
data_separate(d, guess_columns = "mode")

data_separate(d, guess_columns = "max")

# drop left-most column
data_separate(d, guess_columns = "mode", extra = "drop_left")

# merge right-most column
data_separate(d, guess_columns = "mode", extra = "merge_right")

# fill columns with fewer values with left-most values
data_separate(d, guess_columns = "mode", fill = "value_left")

# fill and merge
data_separate(
  d,
  guess_columns = "mode",
  fill = "value_left",
  extra = "merge_right"
)

# multiple columns to split
d <- data.frame(
  x = c("1.a.6", "2.b.7", "3.c.8"),
  y = c("x.y.z", "10.11.12", "m.n.o"),
  stringsAsFactors = FALSE
)
d
# split two columns, default column names
data_separate(d, guess_columns = "mode")

# split into new named columns, repeating column names
data_separate(d, new_columns = c("a", "b", "c"))

# split selected variable new columns
data_separate(d, select = "y", new_columns = c("a", "b", "c"))

# merge multiple split columns
data_separate(
  d,
  new_columns = c("a", "b", "c"),
  merge_multiple = TRUE
)

# merge multiple split columns
data_separate(
  d,
  new_columns = c("a", "b", "c"),
  merge_multiple = TRUE,
  merge_separator = "-"
)

# separate multiple columns, give proper column names
d_sep <- data.frame(
  x = c("1.a.6", "2.b.7.d", "3.c.8", "5.j"),
  y = c("m.n.99.22", "77.f.g.34", "44.9", NA),
  stringsAsFactors = FALSE
)

data_separate(
  d_sep,
  select = c("x", "y"),
  new_columns = list(
    x = c("A", "B", "C"), # separate "x" into three columns
    y = c("EE", "FF", "GG", "HH") # separate "y" into four columns
  ),
  verbose = FALSE
)
}
\seealso{
\code{\link[=data_unite]{data_unite()}}
}
