% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importWQP.R
\name{importWQP}
\alias{importWQP}
\title{Basic Water Quality Portal Data parser}
\usage{
importWQP(obs_url, tz = "UTC", csv = TRUE, convertType = TRUE)
}
\arguments{
\item{obs_url}{character URL to Water Quality Portal#' @keywords data import USGS web service}

\item{tz}{character to set timezone attribute of datetime. Default is UTC
(properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values include "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua",
"America/Phoenix", and "America/Metlakatla"}

\item{csv}{logical. Is the data coming back with a csv or tsv format. Default is \code{FALSE}.
Currently, the summary service does not support tsv, for other services tsv is the safer choice.}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates, datetimes,
numerics based on a standard algorithm. If false, everything is returned as a character.}
}
\value{
retval dataframe raw data returned from the Water Quality Portal. Additionally,
a POSIXct dateTime column is supplied for
start and end times, and converted to UTC. See
\url{https://www.waterqualitydata.us/portal_userguide/} for more information.
}
\description{
Imports data from the Water Quality Portal based on a specified url.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# These examples require an internet connection to run

## Examples take longer than 5 seconds:
\donttest{
rawSampleURL <- constructWQPURL("USGS-01594440", "01075", "", "")

rawSample <- importWQP(rawSampleURL)


STORETex <- constructWQPURL("WIDNR_WQX-10032762", "Specific conductance", "", "")

STORETdata <- importWQP(STORETex)

STORETdata_char <- importWQP(STORETex, convertType = FALSE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{readWQPdata}}, \code{\link{readWQPqw}}, \code{\link{whatWQPsites}}
}
