% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2structure.r
\name{gl2structure}
\alias{gl2structure}
\title{Converts a genlight object to STRUCTURE formated files}
\usage{
gl2structure(
  x,
  indNames = NULL,
  addcolumns = NULL,
  ploidy = 2,
  exportMarkerNames = TRUE,
  outfile = "gl.str",
  outpath = tempdir(),
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data and location
data, lat longs [required].}

\item{indNames}{Specify individuals names to be added 
[if NULL, defaults to indNames(x)].}

\item{addcolumns}{Additional columns to be added before genotypes 
[default NULL].}

\item{ploidy}{Set the ploidy [defaults 2].}

\item{exportMarkerNames}{If TRUE, locus names locNames(x) will be included 
[default TRUE].}

\item{outfile}{File name of the output file (including extension) 
[default "gl.str"].}

\item{outpath}{Path where to save the output file
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.' 
when calling this function to direct output files to your working directory.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\description{
This function exports genlight objects to STRUCTURE formatted files (be aware
there is a gl2faststructure version as well). It is based on the code
provided by Lindsay Clark (see
\url{https://github.com/lvclark/R_genetics_conv}) and this function is
basically a wrapper around her numeric2structure function. See also: Lindsay
Clark. (2017, August 22). lvclark/R_genetics_conv: R_genetics_conv 1.1
(Version v1.1). Zenodo: doi.org/10.5281/zenodo.846816.
}
\examples{
#not run here
#gl2structure(testset.gl)
}
\author{
Bernd Gruber (wrapper) and Lindsay V. Clark [lvclark@illinois.edu]
}
