% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.hwe.r
\name{gl.filter.hwe}
\alias{gl.filter.hwe}
\title{Filters loci that show significant departure from Hardy-Weinberg
 Equilibrium}
\usage{
gl.filter.hwe(
  x,
  subset = "each",
  n.pop.threshold = 1,
  method_sig = "Exact",
  multi_comp = FALSE,
  multi_comp_method = "BY",
  alpha_val = 0.05,
  pvalue_type = "midp",
  cc_val = 0.5,
  min_sample_size = 5,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{subset}{Way to group individuals to perform H-W tests. Either a vector
with population names, 'each', 'all' (see details) [default 'each'].}

\item{n.pop.threshold}{The minimum number of populations where the same locus 
has to be out of H-W proportions to be removed [default 1].}

\item{method_sig}{Method for determining statistical significance: 
'ChiSquare'
or 'Exact' [default 'Exact'].}

\item{multi_comp}{Whether to adjust p-values for multiple comparisons
[default FALSE].}

\item{multi_comp_method}{Method to adjust p-values for multiple comparisons:
'holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY', 'fdr'
(see details) [default 'fdr'].}

\item{alpha_val}{Level of significance for testing [default 0.05].}

\item{pvalue_type}{Type of p-value to be used in the Exact method.
Either 'dost','selome','midp' (see details) [default 'midp'].}

\item{cc_val}{The continuity correction applied to the ChiSquare test
[default 0.5].}

\item{min_sample_size}{Minimum number of individuals per population in which
perform H-W tests [default 5].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A genlight object with the loci departing significantly from H-W
proportions removed.
}
\description{
This function filters out loci showing significant departure from H-W
proportions based on observed frequencies of reference homozygotes,
 heterozygotes and alternate homozygotes.

Loci are filtered out if they show HWE departure either in any one population 
(n.pop.threshold =1) or in at least X number of populations 
(n.pop.threshold > 1).
}
\details{
There are several factors that can cause deviations from Hardy-Weinberg
 proportions including: mutation, finite population size, selection,
 population structure, age structure, assortative mating, sex linkage,
 nonrandom sampling and genotyping errors. Therefore, testing for
 Hardy-Weinberg proportions should be a process that involves a careful
 evaluation of the results, a good place to start is Waples (2015).

 Note that tests for H-W proportions are only valid if there is no population
 substructure (assuming random mating) and have sufficient power only when
 there is sufficient sample size (n individuals > 15).

Populations can be defined in three ways:
\itemize{
\item Merging all populations in the dataset using subset = 'all'.
\item Within each population separately using: subset = 'each'.
\item Within selected populations using for example: subset = 
c('pop1','pop2').
}

Two different statistical methods to test for deviations from Hardy Weinberg
proportions:
\itemize{
\item The classical chi-square test (method_sig='ChiSquare') based on the
function \code{\link[HardyWeinberg]{HWChisq}} of the R package HardyWeinberg.
By default a continuity correction is applied (cc_val=0.5). The
continuity correction can be turned off (by specifying cc_val=0), for example
in cases of extreme allele frequencies in which the continuity correction can
lead to excessive type 1 error rates.
\item The exact test (method_sig='Exact') based on the exact calculations
contained in the function \code{\link[HardyWeinberg]{HWExactStats}} of the R
package HardyWeinberg, and described in Wigginton  et al. (2005). The exact
test is recommended in most cases (Wigginton  et al., 2005).
Three different methods to estimate p-values (pvalue_type) in the Exact test
can be used:
\itemize{
\item 'dost' p-value is computed as twice the tail area of a one-sided test.
\item 'selome' p-value is computed as the sum of the probabilities of all
samples less or equally likely as the current sample.
\item 'midp', p-value is computed as half the probability of the current
sample + the probabilities of all samples that are more extreme.
}
The standard exact p-value is overly conservative, in particular
for small minor allele frequencies. The mid p-value ameliorates this problem
by bringing the rejection rate closer to the nominal level, at the price of
occasionally exceeding the nominal level (Graffelman & Moreno, 2013).
}

Correction for multiple tests can be applied using the following methods
based on the function \code{\link[stats]{p.adjust}}:
\itemize{
\item 'holm' is also known as the sequential Bonferroni technique 
(Rice, 1989).
This method has a greater statistical power than the standard Bonferroni 
test,
however this method becomes very stringent when many tests are performed and
many real deviations from the null hypothesis can go undetected 
(Waples, 2015).
\item 'hochberg' based on Hochberg, 1988.
\item 'hommel' based on Hommel, 1988. This method is more powerful than
Hochberg's, but the difference is usually small.
\item 'bonferroni' in which p-values are multiplied by the number of tests.
This method is very stringent and therefore has reduced power to detect
multiple departures from the null hypothesis.
\item 'BH' based on Benjamini & Hochberg, 1995.
\item 'BY' based on Benjamini & Yekutieli, 2001.
}

The first four methods are designed to give strong control of the family-wise
error rate. The last two methods control the false discovery rate (FDR),
the expected proportion of false discoveries among the rejected hypotheses.
The false discovery rate is a less stringent condition than the family-wise
error rate, so these methods are more powerful than the others, especially
when number of tests is large.
The number of tests on which the adjustment for multiple comparisons is
the number of populations times the number of loci.

\bold{From v2.1} \code{gl.filter.hwe} takes the argument
 \code{n.pop.threshold}.
if \code{n.pop.threshold > 1} loci will be removed only if they are 
concurrently 
significant (after adjustment if applied) out of hwe in >= 
\code{n.pop.threshold > 1}.
}
\examples{
result <- gl.filter.hwe(x = bandicoot.gl)
}
\references{
\itemize{
 \item Benjamini, Y., and Yekutieli, D. (2001). The control of the false
 discovery rate in multiple testing under dependency. Annals of Statistics,
 29, 1165–1188.
\item Graffelman, J. (2015). Exploring Diallelic Genetic Markers: The Hardy
Weinberg Package. Journal of Statistical Software 64:1-23.
\item Graffelman, J. & Morales-Camarena, J. (2008). Graphical tests for
Hardy-Weinberg equilibrium based on the ternary plot. Human Heredity 
65:77-84.
\item Graffelman, J., & Moreno, V. (2013). The mid p-value in exact tests for
Hardy-Weinberg equilibrium. Statistical applications in genetics and
 molecular
biology, 12(4), 433-448.
\item Hochberg, Y. (1988). A sharper Bonferroni procedure for multiple tests
 of significance. Biometrika, 75, 800–803.
\item Hommel, G. (1988). A stagewise rejective multiple test procedure based
 on a modified Bonferroni test. Biometrika, 75, 383–386.
\item Rice, W. R. (1989). Analyzing tables of statistical tests. Evolution,
 43(1), 223-225.
\item Waples, R. S. (2015). Testing for Hardy–Weinberg proportions: have we
lost the plot?. Journal of heredity, 106(1), 1-19.
\item Wigginton, J.E., Cutler, D.J., & Abecasis, G.R. (2005). A Note on Exact
Tests of Hardy-Weinberg Equilibrium. American Journal of Human Genetics
76:887-893.
}
}
\seealso{
\code{\link{gl.report.hwe}}

Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.heterozygosity}()},
\code{\link{gl.filter.ld}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.parent.offspring}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.filter.sexlinked}()},
\code{\link{gl.filter.taglength}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
